/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceDelta;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceDeltaFilter;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.wtp.WtpUtils;

public class ResourceDeltaScanner {
    private final ResourceDeltaFilter filter = new ResourceDeltaFilter();

    public List<ResourceDelta> scanAndFilterEvent(IResourceDelta delta, IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("Analysing changes", 1);
            Logger.debug("Some resources changed...");
            List<ResourceDelta> list = this.scanDelta(delta);
            return list;
        }
        finally {
            progressMonitor.done();
        }
    }

    private List<ResourceDelta> scanDelta(IResourceDelta delta) throws CoreException {
        ArrayList<ResourceDelta> events = new ArrayList<ResourceDelta>();
        if (delta == null) {
            return Collections.emptyList();
        }
        IResource resource = delta.getResource();
        if (resource.getType() == 4 && !((IProject)resource).isOpen()) {
            return Collections.emptyList();
        }
        int flags = delta.getFlags();
        if (WtpUtils.isWebDeploymentDescriptor(resource)) {
            events.add(new ResourceDelta(resource, delta.getKind(), 0));
        } else {
            ResourceDelta event;
            boolean javaFileMarkersChanged;
            boolean isJavaFile = resource.getType() == 1 && "java".equals(resource.getFileExtension());
            boolean javaFileAdded = isJavaFile && delta.getKind() == 1;
            boolean javaFileChanged = isJavaFile && delta.getKind() == 4;
            boolean javaFileRemoved = isJavaFile && delta.getKind() == 2;
            boolean bl = javaFileMarkersChanged = javaFileChanged && (delta.getFlags() & 0x20000) != 0;
            if (javaFileAdded || javaFileRemoved) {
                Logger.debug("File {}  {}", resource, ConstantUtils.getStaticFieldName(IResourceDelta.class, delta.getKind()));
                event = new ResourceDelta(resource, delta.getKind(), flags);
                if (this.filter.applyRules(event)) {
                    events.add(event);
                }
            } else if (javaFileChanged && !javaFileMarkersChanged) {
                Logger.debug("File {}  {}", resource, ConstantUtils.getStaticFieldName(IResourceDelta.class, delta.getKind()));
                event = new ResourceDelta(resource, delta.getKind(), flags);
                if (this.filter.applyRules(event)) {
                    events.add(event);
                }
            } else if (javaFileChanged && javaFileMarkersChanged) {
                IMarkerDelta[] markerDeltas;
                IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                int n = markerDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                    int severity = markerDelta.getAttribute("severity", 0);
                    String type = markerDelta.getType();
                    String message = markerDelta.getAttribute("message", "");
                    if (severity == 2 && type.equals("org.eclipse.jdt.core.problem")) {
                        Logger.debug("Marker delta: {} [{}] {}: \"{}\" at line {} (id={})", markerDelta.getResource().getName(), ConstantUtils.getStaticFieldName(IResourceDelta.class, markerDelta.getKind()), ConstantUtils.getStaticFieldName(IMarker.class, severity, "SEVERITY_"), message, markerDelta.getAttribute("lineNumber"), markerDelta.getId());
                        int flag = markerDelta.getKind() == 1 ? 0x800000 : 0x1000000;
                        ResourceDelta event2 = new ResourceDelta(resource, 4, flag);
                        if (this.filter.applyRules(event2)) {
                            events.add(event2);
                        }
                    }
                    ++n2;
                }
            } else {
                Logger.trace("**ignored** Delta {} [{}]", delta.getResource().getFullPath(), ConstantUtils.getStaticFieldName(IResourceDelta.class, delta.getKind()));
            }
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n3 = 0;
        while (n3 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n3];
            events.addAll(this.scanDelta(childDelta));
            ++n3;
        }
        return events;
    }
}

