/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.Map;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.ws.jaxrs.core.configuration.ProjectNatureUtils;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.MutexJobSchedulingRule;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.ResourceChangedBuildJob;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;

public class JaxrsMetamodelBuilder
extends IncrementalProjectBuilder {
    public static final int SCALE = 10;
    public static final String BUILDER_ID = "org.jboss.tools.ws.jaxrs.metamodelBuilder";
    public static final QualifiedName JAXRS_ELEMENT_CHANGE_LISTENER_NAME = new QualifiedName("org.jboss.tools.ws.jaxrs.core", "jaxrsPostReconcileListener");

    protected final IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (!ProjectNatureUtils.isProjectNatureInstalled(project, "org.jboss.tools.ws.jaxrs.nature")) {
            Logger.warn("Project '" + project.getName() + "' is not a JAX-RS project.");
            return null;
        }
        this.logBuild(kind, args, project);
        switch (kind) {
            case 6: 
            case 9: 
            case 10: {
                this.build(kind, project, monitor);
            }
        }
        return new IProject[]{project};
    }

    protected final void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    private void build(int buildKind, IProject project, IProgressMonitor progressMonitor) {
        Logger.debug("Building JAX-RS metamodel for project '" + project.getName() + "'");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ResourceChangedBuildJob job = new ResourceChangedBuildJob(javaProject, (IResourceChangeEvent)this.getResourceChangeEvent(project, buildKind));
        job.setRule(new MutexJobSchedulingRule(javaProject));
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Logger.warn("JAX-RS Metamodel build job was interrupted", e);
        }
    }

    private ResourceChangeEvent getResourceChangeEvent(IProject project, int buildKind) {
        return new ResourceChangeEvent((Object)project, 1, buildKind, this.getDelta(project));
    }

    private void logBuild(int kind, Map args, IProject project) {
        StringBuilder sb = new StringBuilder("JAX-RS Builder called after '");
        sb.append(ConstantUtils.getStaticFieldName(IncrementalProjectBuilder.class, kind));
        sb.append("' on project '").append(project.getName()).append("'");
        Logger.debug(sb.toString());
    }
}

