/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedBuildTask;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementDelta;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.CompilationUnitsRepository;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElementChangedListener;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsHttpMethodChangedListener
implements IJaxrsElementChangedListener {
    @Override
    public void notifyElementChanged(JaxrsElementDelta delta) {
        if (delta != null && delta.getElement().getElementKind() == EnumElementKind.HTTP_METHOD) {
            try {
                JaxrsHttpMethod httpMethod = (JaxrsHttpMethod)delta.getElement();
                if (httpMethod.isBuiltIn()) {
                    return;
                }
                JaxrsMetamodel metamodel = (JaxrsMetamodel)delta.getElement().getMetamodel();
                Set<IMethod> affectedMethods = this.getAffectedMethods(delta);
                JavaElementDelta affectedMethodsDelta = new JavaElementDelta((IJavaElement)metamodel.getJavaProject(), null, 4, 0);
                for (IMethod affectedMethod : affectedMethods) {
                    CompilationUnit ast = CompilationUnitsRepository.getInstance().getAST(affectedMethod.getCompilationUnit());
                    JavaElementDelta affectedMethodDelta = new JavaElementDelta((IJavaElement)affectedMethod, ast, 4, 0);
                    Annotation httpMethodAnnotation = JdtUtils.resolveAnnotation((IMember)affectedMethod, ast, httpMethod.getJavaClassName());
                    if (httpMethodAnnotation == null) continue;
                    affectedMethodDelta.addAffectedAnnotation(new JavaElementDelta((IJavaElement)httpMethodAnnotation.getJavaAnnotation(), ast, delta.getDeltaKind(), 0));
                    affectedMethodsDelta.addAffectedElementDelta(affectedMethodDelta);
                }
                JavaElementChangedBuildTask elementChangedBuildTask = new JavaElementChangedBuildTask(new ElementChangedEvent((IJavaElementDelta)affectedMethodsDelta, 4));
                elementChangedBuildTask.execute((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Logger.error("Failed to process change after HTTP Method addition/removal", e);
            }
        }
    }

    private Set<IMethod> getAffectedMethods(JaxrsElementDelta delta) throws CoreException {
        JaxrsMetamodel metamodel = (JaxrsMetamodel)delta.getElement().getMetamodel();
        JaxrsHttpMethod httpMethod = (JaxrsHttpMethod)delta.getElement();
        switch (delta.getDeltaKind()) {
            case 1: {
                return JavaElementsSearcher.findAnnotatedMethods(metamodel.getJavaProject(), httpMethod.getJavaClassName(), (IProgressMonitor)new NullProgressMonitor());
            }
            case 2: {
                Set<IJaxrsResourceMethod> annotatedResourceMethods = metamodel.findResourceMethodsByAnnotation(httpMethod.getJavaClassName());
                HashSet<IMethod> affectedMethods = new HashSet<IMethod>();
                for (IJaxrsResourceMethod resourceMethod : annotatedResourceMethods) {
                    affectedMethods.add(resourceMethod.getJavaElement());
                }
                return affectedMethods;
            }
        }
        return Collections.emptySet();
    }
}

