/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedEvent;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementDeltaFilter;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.CompilationUnitsRepository;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodSignature;

public class JavaElementDeltaScanner {
    private final JavaElementDeltaFilter javaElementChangedEventFilter = new JavaElementDeltaFilter();
    private final CompilationUnitsRepository compilationUnitsRepository = CompilationUnitsRepository.getInstance();

    public List<JavaElementChangedEvent> scanAndFilterEvent(ElementChangedEvent event, IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("Analysing changes", 1);
            Logger.debug("Some java elements changed on a {} event ", ConstantUtils.getStaticFieldName(ElementChangedEvent.class, event.getType()));
            List<JavaElementChangedEvent> list = this.scanDelta(event.getDelta(), event.getType());
            return list;
        }
        finally {
            progressMonitor.done();
        }
    }

    private List<JavaElementChangedEvent> scanDelta(IJavaElementDelta delta, int eventType) throws CoreException {
        JavaElementChangedEvent event;
        JavaElementChangedEvent event2;
        IPackageFragmentRoot packageFragmentRoot;
        ArrayList<JavaElementChangedEvent> events = new ArrayList<JavaElementChangedEvent>();
        IJavaElement element = delta.getElement();
        if (element == null) {
            Logger.debug("** skipping this build because the delta element is null **");
            return Collections.emptyList();
        }
        if (element.getElementType() == 2 && !element.getJavaProject().isOpen() && delta.getFlags() != 512) {
            Logger.debug("** skipping this build because the java project is closed. **");
            return Collections.emptyList();
        }
        if (element.getElementType() == 3 ? !(packageFragmentRoot = (IPackageFragmentRoot)element).isExternal() && (packageFragmentRoot.getResource() == null || !packageFragmentRoot.getResource().exists()) : element.getResource() == null || !element.getResource().exists()) {
            return Collections.emptyList();
        }
        int elementKind = element.getElementType();
        int deltaKind = JavaElementDeltaScanner.retrieveDeltaKind(delta);
        int flags = delta.getFlags();
        if (elementKind == 2 && this.javaElementChangedEventFilter.apply(event2 = new JavaElementChangedEvent(element, delta.getKind(), eventType, null, delta.getFlags()))) {
            events.add(event2);
            return events;
        }
        CompilationUnit compilationUnitAST = this.getCompilationUnitAST(delta);
        if (elementKind == 5) {
            ICompilationUnit compilationUnit = (ICompilationUnit)element;
            if (compilationUnit.exists() && compilationUnit.isWorkingCopy() && compilationUnitAST != null) {
                boolean computeDiffs = this.requiresDiffsComputation(flags);
                Map<String, JavaMethodSignature> diffs = this.compilationUnitsRepository.mergeAST(compilationUnit, compilationUnitAST, computeDiffs);
                for (Map.Entry<String, JavaMethodSignature> diff : diffs.entrySet()) {
                    IJavaMethodSignature methodSignature = diff.getValue();
                    JavaElementChangedEvent event3 = new JavaElementChangedEvent((IJavaElement)methodSignature.getJavaMethod(), 4, eventType, compilationUnitAST, 0x2000000);
                    if (!this.javaElementChangedEventFilter.apply(event3)) continue;
                    events.add(event3);
                }
                IProblem[] problems = compilationUnitAST.getProblems();
                Map<IProblem, IJavaElement> solvedProblems = this.compilationUnitsRepository.mergeProblems(compilationUnit, problems);
                for (Map.Entry<IProblem, IJavaElement> solvedProblem : solvedProblems.entrySet()) {
                    IJavaElement solvedElement = solvedProblem.getValue();
                    JavaElementChangedEvent event4 = new JavaElementChangedEvent(solvedElement, 4, eventType, compilationUnitAST, 0x8000000);
                    if (!this.javaElementChangedEventFilter.apply(event4)) continue;
                    events.add(event4);
                }
            }
        } else if (compilationUnitAST != null && this.javaElementChangedEventFilter.apply(event = new JavaElementChangedEvent(element, deltaKind, eventType, compilationUnitAST, flags))) {
            events.add(event);
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta affectedChild = iJavaElementDeltaArray[n2];
            events.addAll(this.scanDelta(affectedChild, eventType));
            ++n2;
        }
        iJavaElementDeltaArray = delta.getAnnotationDeltas();
        n = iJavaElementDeltaArray.length;
        n2 = 0;
        while (n2 < n) {
            IJavaElementDelta annotation = iJavaElementDeltaArray[n2];
            events.addAll(this.scanDelta(annotation, eventType));
            ++n2;
        }
        return events;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CompilationUnit getCompilationUnitAST(IJavaElementDelta delta) throws JavaModelException {
        CompilationUnit compilationUnitAST = null;
        IJavaElement element = delta.getElement();
        int elementKind = element.getElementType();
        int deltaKind = JavaElementDeltaScanner.retrieveDeltaKind(delta);
        if (elementKind != 5) return this.compilationUnitsRepository.getAST(element.getResource());
        ICompilationUnit compilationUnit = (ICompilationUnit)element;
        switch (deltaKind) {
            case 1: {
                return this.compilationUnitsRepository.getAST(compilationUnit);
            }
            case 4: {
                if (!compilationUnit.isWorkingCopy()) return this.compilationUnitsRepository.getAST(compilationUnit);
                compilationUnitAST = delta.getCompilationUnitAST();
                if (compilationUnitAST != null) return compilationUnitAST;
                return JdtUtils.parse(compilationUnit, (IProgressMonitor)new NullProgressMonitor());
            }
            case 2: {
                this.compilationUnitsRepository.removeAST(compilationUnit);
            }
            default: {
                return compilationUnitAST;
            }
        }
    }

    private boolean requiresDiffsComputation(int flags) {
        return flags == 540673;
    }

    private static int retrieveDeltaKind(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        int elementType = element.getElementType();
        int flags = delta.getFlags();
        switch (elementType) {
            case 3: {
                switch (flags) {
                    case 64: {
                        return 1;
                    }
                    case 128: {
                        return 2;
                    }
                }
            }
        }
        return delta.getKind();
    }
}

