/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.EventObject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.IJavaElementDeltaFlag;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;

public class JavaElementChangedEvent
extends EventObject {
    private static final long serialVersionUID = 8821221398378359798L;
    public static final int NO_FLAG = 0;
    private final int eventType;
    private final IJavaElement element;
    private final int deltaKind;
    private final int flags;
    private final CompilationUnit compilationUnitAST;

    public JavaElementChangedEvent(IJavaElement element, int deltaKind, int eventType, CompilationUnit compilationUnitAST, int flags) {
        super(element);
        this.element = element;
        this.deltaKind = deltaKind;
        this.eventType = eventType;
        this.compilationUnitAST = compilationUnitAST;
        this.flags = flags;
    }

    public IJavaElement getElement() {
        return this.element;
    }

    public int getKind() {
        return this.deltaKind;
    }

    public int getEventType() {
        return this.eventType;
    }

    public CompilationUnit getCompilationUnitAST() {
        return this.compilationUnitAST;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("JavaElementDelta ").append("[").append(ConstantUtils.getStaticFieldName(ElementChangedEvent.class, this.eventType)).append("] ").append(ConstantUtils.getStaticFieldName(IJavaElement.class, this.element.getElementType())).append(" '").append(this.element.getElementName()).append("' ");
        if (JdtUtils.isWorkingCopy(this.element)) {
            result.append(" [*working copy*]");
        }
        if (this.compilationUnitAST != null) {
            result.append("[with AST] ");
        } else {
            result.append("[*without* AST] ");
        }
        result.append(ConstantUtils.getStaticFieldName(IJavaElementDeltaFlag.class, this.deltaKind).toLowerCase());
        if (this.flags > 0) {
            int[] f = ConstantUtils.splitConstants(IJavaElementDeltaFlag.class, this.flags, "F_");
            result.append(":{");
            int i = 0;
            while (i < f.length) {
                result.append(ConstantUtils.getStaticFieldName(IJavaElementDeltaFlag.class, f[i], "F_"));
                if (i < f.length - 1) {
                    result.append("+");
                }
                ++i;
            }
            result.append("}");
        } else {
            result.append(":{no flag}");
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.deltaKind;
        result = 31 * result + this.eventType;
        result = 31 * result + (this.element == null ? 0 : this.element.getElementType());
        result = 31 * result + (this.element == null ? 0 : this.element.getElementName().hashCode());
        result = 31 * result + this.flags;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaElementChangedEvent other = (JavaElementChangedEvent)obj;
        if (this.deltaKind != other.deltaKind) {
            return false;
        }
        if (this.eventType != other.eventType) {
            return false;
        }
        if (this.element == null) {
            return false;
        }
        if (this.element != null && other.element == null) {
            return false;
        }
        if (!(this.element == null || other.element == null || this.element.getElementName().equals(other.element.getElementName()) && this.element.getElementType() == other.element.getElementType())) {
            return false;
        }
        return this.flags == other.flags;
    }
}

