/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.configuration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public final class ProjectNatureUtils {
    public static final String JAXRS_NATURE_ID = "org.jboss.tools.ws.jaxrs.nature";

    private ProjectNatureUtils() {
    }

    public static boolean isProjectNatureInstalled(IProject project, String natureId) throws CoreException {
        String[] natures;
        if (!project.isOpen()) {
            return false;
        }
        String[] stringArray = natures = project.getDescription().getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals(natureId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean installProjectNature(IProject project, String natureId) throws CoreException {
        if (ProjectNatureUtils.isProjectNatureInstalled(project, natureId)) {
            return false;
        }
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
        return true;
    }

    public static boolean uninstallProjectNature(IProject project, String natureId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] natures = desc.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(natureId)) {
                String[] newNatureIds = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatureIds, 0, i);
                System.arraycopy(natures, i + 1, newNatureIds, i, natures.length - i - 1);
                desc.setNatureIds(newNatureIds);
                project.setDescription(desc, null);
                return true;
            }
            ++i;
        }
        return false;
    }
}

