/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerLabelProvider;

public class QueryContribution {
    private static Boolean TRUE_BOOL = new Boolean(true);
    private static HashMap<Viewer, QueryContribution> map = new HashMap();
    private String filterText;
    private String oldFilterText;
    private HashMap<Object, Boolean> cache = new HashMap();
    private JMXNavigator navigator;
    private boolean requiresRefine;

    public static QueryContribution getContributionFor(Viewer v) {
        return map.get(v);
    }

    public static String getFilterText(Viewer viewer) {
        QueryContribution qc = map.get(viewer);
        if (qc != null) {
            return qc.filterText;
        }
        return null;
    }

    public QueryContribution(JMXNavigator navigator) {
        this.navigator = navigator;
        map.put((Viewer)navigator.getCommonViewer(), this);
        this.addListener();
    }

    protected void addListener() {
        this.navigator.getFilterText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String neww;
                QueryContribution.this.oldFilterText = QueryContribution.this.filterText;
                QueryContribution.this.filterText = QueryContribution.this.navigator.getFilterText().getText();
                String old = QueryContribution.this.oldFilterText == null ? "" : QueryContribution.this.oldFilterText;
                String string = neww = QueryContribution.this.filterText == null ? "" : QueryContribution.this.filterText;
                if (old.equals("") || neww.equals("") || !neww.startsWith(old)) {
                    QueryContribution.this.clearCache();
                } else if (neww.startsWith(old) && !neww.equals(old)) {
                    QueryContribution.this.requiresRefine = true;
                }
                QueryContribution.this.cacheEntry(QueryContribution.this.requiresRefine, (ITreeContentProvider)QueryContribution.this.navigator.getCommonViewer().getContentProvider());
                QueryContribution.this.navigator.getCommonViewer().refresh();
            }
        });
    }

    protected void clearCache() {
        this.cache = new HashMap();
        this.requiresRefine = false;
    }

    protected void cacheEntry(boolean refine, ITreeContentProvider provider) {
        Object[] elements = provider.getElements(this.navigator.getCommonViewer().getInput());
        int i = 0;
        while (i < elements.length) {
            this.cache(elements[i], refine, provider);
            ++i;
        }
    }

    protected boolean cache(Object o, boolean refine, ITreeContentProvider provider) {
        if (!refine && this.cache.get(o) != null) {
            return this.cache.get(o);
        }
        String elementAsString = MBeanExplorerLabelProvider.getText2(o);
        if (elementAsString != null && this.filterText != null && elementAsString.contains(this.filterText)) {
            this.recurseTrue(o, provider);
            return true;
        }
        boolean belongs = false;
        Object[] children = provider.getChildren(o);
        int i = 0;
        while (i < children.length) {
            Boolean tmp = this.cache.get(children[i]);
            if (!refine || tmp != null && tmp.booleanValue()) {
                belongs |= this.cache(children[i], refine, provider);
            }
            ++i;
        }
        this.cache.put(o, new Boolean(belongs));
        return belongs;
    }

    protected void recurseTrue(Object o, ITreeContentProvider provider) {
        this.cache.put(o, new Boolean(true));
        Object[] children = provider.getChildren(o);
        int i = 0;
        while (i < children.length) {
            this.recurseTrue(children[i], provider);
            ++i;
        }
    }

    public boolean shouldShow(Object element, Object parentElement) {
        String filterText = this.filterText;
        if (filterText != null && !"".equals(filterText)) {
            boolean tmp = this.cache.get(element) != null && this.cache.get(element) != false;
            return tmp;
        }
        return true;
    }

    public void dispose() {
        this.clearCache();
        this.oldFilterText = null;
        this.filterText = null;
    }

    public static class QueryFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            QueryContribution contrib = QueryContribution.getContributionFor(viewer);
            if (contrib != null) {
                return contrib.shouldShow(element, parentElement);
            }
            return true;
        }
    }
}

