/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.core.internal.io;

import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.core.document.Style;
import org.jboss.tools.aesh.core.internal.ansi.Command;
import org.jboss.tools.aesh.core.internal.io.AeshOutputHandler;

public class DocumentHandler
implements AeshOutputHandler {
    private Document document;

    @Override
    public void handleOutput(String output) {
        if ("".equals(output)) {
            return;
        }
        if (this.document != null) {
            output.replaceAll("\r", "");
            Style style = this.document.getCurrentStyle();
            if (style != null) {
                int increase = this.document.getCursorOffset() - this.document.getLength() + output.length();
                style.setLength(style.getLength() + increase);
            }
            this.document.replace(this.document.getCursorOffset(), this.document.getLength() - this.document.getCursorOffset(), output);
            this.document.moveCursorTo(this.document.getCursorOffset() + output.length());
        }
    }

    @Override
    public void handleCommand(Command command) {
        if (this.document != null) {
            command.handle(this.document);
        }
    }

    public void setDocument(Document document) {
        this.document = document;
    }
}

