/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.core.console;

import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.tools.aesh.core.console.Console;
import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.core.internal.io.AeshInputStream;
import org.jboss.tools.aesh.core.internal.io.AeshOutputFilter;
import org.jboss.tools.aesh.core.internal.io.AeshOutputStream;
import org.jboss.tools.aesh.core.internal.io.CommandFilter;
import org.jboss.tools.aesh.core.internal.io.DocumentHandler;

public abstract class AbstractConsole
implements Console {
    private AeshInputStream inputStream = null;
    private AeshOutputStream outputStream;
    private AeshOutputStream errorStream = null;
    private DocumentHandler handler = new DocumentHandler();
    private AeshOutputFilter filter = new CommandFilter(this.handler);

    @Override
    public abstract void start();

    @Override
    public abstract void stop();

    @Override
    public void connect(Document document) {
        this.setInputStream(new AeshInputStream());
        this.setOutputStream(new AeshOutputStream(this.filter));
        this.setErrorStream(new AeshOutputStream(this.filter));
        this.setHandlerDocument(document);
    }

    @Override
    public void disconnect() {
        this.setHandlerDocument(null);
        this.setErrorStream(null);
        this.setOutputStream(null);
        this.setInputStream(null);
    }

    @Override
    public void sendInput(String input) {
        if (this.inputStream != null) {
            this.inputStream.append(input);
        }
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected OutputStream getErrorStream() {
        return this.errorStream;
    }

    void setInputStream(AeshInputStream inputStream) {
        this.inputStream = inputStream;
    }

    void setOutputStream(AeshOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    void setErrorStream(AeshOutputStream errorStream) {
        this.errorStream = errorStream;
    }

    void setHandlerDocument(Document document) {
        this.handler.setDocument(document);
    }

    @Override
    public Object getCurrentResource() {
        return null;
    }
}

