/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import tern.eclipse.ide.ui.TernUIPlugin;

public class EditorUtils {
    public static IEditorPart openInEditor(IFile file, int start, int length, boolean activate) {
        IEditorPart editor = null;
        IWorkbenchPage page = TernUIPlugin.getActivePage();
        try {
            if (start > 0) {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
                ITextEditor textEditor = null;
                if (editor instanceof ITextEditor) {
                    textEditor = (ITextEditor)editor;
                } else if (editor instanceof IAdaptable) {
                    textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                }
                if (textEditor != null) {
                    textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    textEditor.selectAndReveal(start, length);
                    page.activate((IWorkbenchPart)editor);
                } else {
                    IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("lineNumber", start);
                    editor = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)activate);
                    marker.delete();
                }
            } else {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return editor;
    }

    public static IFile getFile(IEditorPart editor) {
        IResource resource = EditorUtils.getResource(editor);
        return resource != null && resource.getType() == 1 ? (IFile)resource : null;
    }

    public static IResource getResource(IEditorPart editor) {
        return (IResource)editor.getEditorInput().getAdapter(IResource.class);
    }

    public static ITextEditor getEditor(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(true);
        if (part != null && part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return null;
    }

    public static IDocument getDocument(ITextEditor editor) {
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public static ISourceViewer getSourceViewer(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        return viewer;
    }
}

