/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.contentassist;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.jface.TernImagesRegistry;
import tern.eclipse.jface.contentassist.TernCompletionProposal;
import tern.server.protocol.completions.Parameter;
import tern.server.protocol.completions.TernCompletionItem;
import tern.utils.StringUtils;

public class JSTernCompletionProposal
extends TernCompletionProposal {
    private static final String COMMA = ",";
    private IRegion fSelectedRegion;
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;
    private ITextViewer fTextViewer;
    private boolean fReplacementStringComputed;
    private boolean fToggleEating;

    public JSTernCompletionProposal(String name, String type, String origin, Object doc, int pos, int startOffset) {
        super(name, type, origin, doc, pos, startOffset);
    }

    protected Image getDefaultImage() {
        Image image = TernImagesRegistry.getImage((TernCompletionItem)this, (boolean)true);
        if (image != null) {
            return image;
        }
        String origin = super.getOrigin();
        if (!StringUtils.isEmpty((String)origin)) {
            image = TernUIPlugin.getTernDescriptorManager().getImage(origin);
        }
        return image != null ? image : TernImagesRegistry.getImage((String)"tern.eclipse.jface.IMG_UNKNOWN");
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = viewer;
        }
        Point selection = viewer.getSelectedRange();
        this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        int newLength = selection.x + selection.y - this.getReplacementOffset();
        if (this.insertCompletion() ^ this.fToggleEating && newLength >= 0) {
            this.setReplacementLength(newLength);
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    private boolean insertCompletion() {
        return true;
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.fArgumentOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fArgumentOffsets[i], this.fArgumentLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    public final void setReplacementString(String replacementString) {
        this.fReplacementStringComputed = true;
        super.setReplacementString(replacementString);
    }

    protected String computeReplacementString() {
        List parameters = super.getParameters();
        if (parameters == null) {
            return super.getReplacementString();
        }
        int count = parameters.size();
        this.fArgumentOffsets = new int[count];
        this.fArgumentLengths = new int[count];
        StringBuilder buffer = new StringBuilder(String.valueOf(super.getName()));
        buffer.append("(");
        this.setCursorPosition(buffer.length());
        String paramName = null;
        int i = 0;
        while (i != count) {
            if (i != 0) {
                buffer.append(COMMA);
            }
            paramName = ((Parameter)parameters.get(i)).getName();
            this.fArgumentOffsets[i] = buffer.length();
            buffer.append(paramName);
            this.fArgumentLengths[i] = paramName.length();
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getAdditionalProposalInfo() {
        String returnType;
        String doc = super.getAdditionalProposalInfo();
        StringBuilder info = new StringBuilder(doc != null ? doc : "");
        List parameters = this.getParameters();
        info.append("<dl>");
        if (parameters != null) {
            info.append("<dt>Parameters:</dt>");
            for (Parameter parameter : parameters) {
                info.append("<dd><b>");
                if (!parameter.isRequired()) {
                    info.append("[");
                }
                info.append(parameter.getName());
                if (!parameter.isRequired()) {
                    info.append("]");
                }
                info.append("</b>: ");
                info.append(parameter.getType());
                info.append("</dd>");
            }
        }
        if (!StringUtils.isEmpty((String)(returnType = this.getJsType()))) {
            info.append("<dt>Returns:</dt>");
            info.append("<dd>");
            info.append(returnType);
            info.append("</dd>");
        }
        info.append("</dl>");
        return info.toString();
    }
}

