/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.properties;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tern.eclipse.ide.core.IDETernProject;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.properties.AbstractTernPropertyPage;
import tern.eclipse.ide.internal.ui.properties.TernScriptPathsBlock;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.TernUIPlugin;

public class TernScriptPathsPropertyPage
extends AbstractTernPropertyPage
implements IWorkbenchPreferencePage {
    private TernScriptPathsBlock scriptPathsBlock;

    public TernScriptPathsPropertyPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(TernUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        IDETernProject ternProject = null;
        try {
            ternProject = this.getTernProject();
        }
        catch (CoreException coreException) {}
        this.scriptPathsBlock = new TernScriptPathsBlock(ternProject);
        this.scriptPathsBlock.createControl(parent);
        Control control = this.scriptPathsBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.loadScriptPaths();
        this.applyDialogFont(parent);
        return parent;
    }

    public boolean performOk() {
        this.scriptPathsBlock.saveColumnSettings();
        List<ITernScriptPath> scriptPaths = this.scriptPathsBlock.getTernScriptPaths();
        try {
            IDETernProject ternProject = this.getTernProject();
            ternProject.setScriptPaths(scriptPaths);
            ternProject.save();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
        return super.performOk();
    }

    private void loadScriptPaths() {
        try {
            IDETernProject ternProject = this.getTernProject();
            this.scriptPathsBlock.setTernScriptPaths(ternProject.getScriptPaths());
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while loading scriptPaths.", e);
        }
    }
}

