/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.properties;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tern.TernProject;
import tern.eclipse.ide.core.IDETernProject;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.properties.AbstractTernPropertyPage;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.server.ITernModule;
import tern.utils.TernModuleHelper;

public class TernModulesPropertyPage
extends AbstractTernPropertyPage
implements IWorkbenchPreferencePage {
    private TernModulesBlock modulesBlock;

    public TernModulesPropertyPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(TernUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.modulesBlock = new TernModulesBlock(this.getResource().getProject(), TernUIMessages.TernModulesPropertyPage_desc);
        this.modulesBlock.createControl(parent);
        Control control = this.modulesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.modulesBlock.loadModules();
        this.applyDialogFont(parent);
        return parent;
    }

    public boolean performOk() {
        this.modulesBlock.saveColumnSettings();
        Object[] checkedModules = this.modulesBlock.getCheckedModules();
        try {
            IDETernProject ternProject = this.getTernProject();
            ternProject.clearPlugins();
            ternProject.clearLibs();
            Object[] objectArray = checkedModules;
            int n = checkedModules.length;
            int n2 = 0;
            while (n2 < n) {
                Object module = objectArray[n2];
                TernModuleHelper.update((ITernModule)((ITernModule)module), (TernProject)ternProject);
                ++n2;
            }
            ternProject.save();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
        return super.performOk();
    }
}

