/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.controls.TernModuleOptionsPanel;
import tern.eclipse.ide.internal.ui.descriptors.TernDescriptor;
import tern.eclipse.ide.ui.descriptors.ITernDescriptor;
import tern.eclipse.ide.ui.descriptors.ITernDescriptorManager;
import tern.server.ITernModule;

public class TernDescriptorManager
implements ITernDescriptorManager,
IRegistryChangeListener {
    private static final String EXTENSION_TERN_DESCRIPTORS = "ternDescriptors";
    private static final TernDescriptorManager INSTANCE = new TernDescriptorManager();
    private Map<String, ITernDescriptor> ternDescriptors;
    private boolean registryListenerIntialized = false;

    public static TernDescriptorManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.ui", EXTENSION_TERN_DESCRIPTORS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernDescriptorDelta(delta);
                ++n2;
            }
        }
    }

    @Override
    public Image getImage(String id) {
        ITernDescriptor descriptor = this.getTernDescriptor(id);
        if (descriptor != null) {
            return descriptor.getImage();
        }
        return null;
    }

    @Override
    public Composite createOptionsPanel(Composite parent, ITernModule module, IProject project) {
        return new TernModuleOptionsPanel(parent, module, project);
    }

    @Override
    public ITernDescriptor getTernDescriptor(String id) {
        if (this.ternDescriptors == null) {
            this.loadTernDescriptors();
        }
        return this.ternDescriptors.get(id);
    }

    private synchronized void loadTernDescriptors() {
        if (this.ternDescriptors != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternDescriptors extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.ui", EXTENSION_TERN_DESCRIPTORS);
        HashMap<String, ITernDescriptor> list = new HashMap<String, ITernDescriptor>(cf.length);
        this.addTernDescriptors(cf, list);
        this.addRegistryListenerIfNeeded();
        this.ternDescriptors = list;
        Trace.trace((byte)7, "-<- Done loading .ternDescriptors extension point -<-");
    }

    private synchronized void addTernDescriptors(IConfigurationElement[] cf, Map<String, ITernDescriptor> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                TernDescriptor ternDescriptor = new TernDescriptor(ce);
                list.put(ternDescriptor.getId(), ternDescriptor);
                Trace.trace((byte)7, "  Loaded ternDescriptor: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load ternDescriptor: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    protected void handleTernDescriptorDelta(IExtensionDelta delta) {
        if (this.ternDescriptors == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        HashMap<String, ITernDescriptor> list = new HashMap<String, ITernDescriptor>(this.ternDescriptors);
        if (delta.getKind() == 1) {
            this.addTernDescriptors(cf, list);
        } else {
            int size = list.size();
            TernDescriptor[] st = new TernDescriptor[size];
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        st[i].dispose();
                        list.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.ternDescriptors = list;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.ui");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

