/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.descriptors.ITernDescriptor;
import tern.utils.StringUtils;

public class TernDescriptor
implements ITernDescriptor {
    private final String id;
    private final String imageKey;

    public TernDescriptor(IConfigurationElement ce) {
        this.id = ce.getAttribute("id");
        this.imageKey = this.getImageKey(ce, this.id);
    }

    private String getImageKey(IConfigurationElement ce, String id) {
        String iconPath = ce.getAttribute("icon");
        if (StringUtils.isEmpty((String)iconPath)) {
            return null;
        }
        String name = ce.getDeclaringExtension().getContributor().getName();
        String imageKey = "ternDescriptor_" + name + id;
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)name, (String)iconPath);
        if (imageDescriptor == null && iconPath != null && iconPath.length() > 0) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        ImageResource.registerImageDescriptor(imageKey, imageDescriptor);
        return imageKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Image getImage() {
        if (this.imageKey == null) {
            return null;
        }
        return ImageResource.getImage(this.imageKey);
    }

    public void dispose() {
    }
}

