/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.controls;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.controls.AbstractTernModulePanel;
import tern.eclipse.ide.internal.ui.controls.FilenameEditingSupport;
import tern.eclipse.ide.internal.ui.controls.PathEditingSupport;
import tern.eclipse.ide.internal.ui.dialogs.FolderSelectionDialog;
import tern.eclipse.ide.internal.ui.dialogs.OpenResourceDialog;
import tern.eclipse.ide.ui.viewers.JsonContentProvider;
import tern.eclipse.ide.ui.viewers.JsonLabelProvider;
import tern.eclipse.ide.ui.viewers.MemberWrapper;
import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataOption;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.ModuleType;
import tern.server.protocol.JsonHelper;
import tern.utils.StringUtils;

public class TernModuleOptionsPanel
extends AbstractTernModulePanel {
    public TernModuleOptionsPanel(Composite parent, ITernModule module, IProject project) {
        super(parent, module, project);
    }

    @Override
    protected void createUI(Composite parent, ITernModule module, IProject project) {
        GridLayout layout = new GridLayout(2, false);
        super.setLayout((Layout)layout);
        TernModuleMetadata metadata = module.getMetadata();
        if (metadata != null && module.getModuleType() == ModuleType.Configurable) {
            JsonObject jsonOptions = this.getOptions((ITernModuleConfigurable)module);
            Collection options = metadata.getOptions();
            for (TernModuleMetadataOption option : options) {
                this.createUI(parent, jsonOptions, project, option);
            }
        }
    }

    protected void createUI(Composite parent, JsonObject options, IProject project, TernModuleMetadataOption option) {
        String name = option.getName();
        String description = option.getDescription();
        String type = option.getType();
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(name + ":");
        label.setToolTipText(description);
        if ("boolean".equals(type)) {
            this.createBooleanOption(parent, name, options);
        } else if ("string".equals(type)) {
            this.createStringOption(parent, name, options);
        } else if ("path".equals(type)) {
            if (project != null) {
                this.createPathOption(parent, project, name, options);
            } else {
                this.createStringOption(parent, name, options);
            }
        } else if ("path[]".equals(type)) {
            this.createPathArrayOption(parent, project, name, options);
        } else {
            this.createJsonOption(parent, name, options);
        }
    }

    protected void createBooleanOption(Composite parent, final String name, final JsonObject options) {
        final Button checkbox = new Button(parent, 32);
        checkbox.setLayoutData((Object)new GridData(768));
        boolean value = JsonHelper.getBoolean((JsonObject)options, (String)name, (boolean)false);
        checkbox.setSelection(value);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                options.set(name, checkbox.getSelection());
            }
        });
    }

    protected void createStringOption(Composite parent, final String name, final JsonObject options) {
        final Text textField = new Text(parent, 2048);
        textField.setLayoutData((Object)new GridData(768));
        String initialValue = JsonHelper.getString((JsonValue)options.get(name));
        textField.setText(initialValue != null ? initialValue : "");
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = textField.getText();
                if (StringUtils.isEmpty((String)value)) {
                    options.remove(name);
                } else {
                    options.set(name, value);
                }
            }
        });
    }

    protected void createPathOption(Composite ancestor, final IProject project, final String name, final JsonObject options) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(768));
        final Text textField = new Text(parent, 2048);
        textField.setLayoutData((Object)new GridData(768));
        final ControlDecoration deco = new ControlDecoration((Control)textField, 16512);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        deco.setDescriptionText(TernUIMessages.TernModuleOptionsPanel_validatePath);
        deco.setImage(image);
        deco.hide();
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = textField.getText();
                if (StringUtils.isEmpty((String)value)) {
                    options.remove(name);
                } else {
                    IFolder folder = project.getFolder(value);
                    if (folder != null && folder.exists()) {
                        deco.hide();
                    } else {
                        deco.show();
                    }
                    options.set(name, value);
                }
            }
        });
        String initialValue = JsonHelper.getString((JsonValue)options.get(name));
        textField.setText(initialValue != null ? initialValue : "");
        Button pathButton = new Button(parent, 8);
        pathButton.setText(TernUIMessages.Button_selectPath);
        pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernModuleOptionsPanel.this.openFolderDialog(textField, project);
            }
        });
    }

    private void openFolderDialog(Text textField, IProject project) {
        SelectionDialog dialog = this.createFolderDialog(textField, project);
        if (dialog.open() != 0) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0) {
            IResource resource = (IResource)results[0];
            String path = resource.getProjectRelativePath().toString();
            textField.setText(path);
        }
    }

    private SelectionDialog createFolderDialog(Text textField, final IProject project) {
        IFolder folder;
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(TernUIMessages.TernModuleOptionsPanel_selectPathDialogTitle);
        IFolder iFolder = folder = StringUtils.isEmpty((String)textField.getText()) ? null : project.getFolder(textField.getText());
        if (folder != null && folder.exists()) {
            dialog.setInitialSelection(folder);
        }
        dialog.setInput(project);
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    IProject p = (IProject)element;
                    return p.equals((Object)project);
                }
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    return container.getType() == 2;
                }
                return false;
            }
        };
        dialog.addFilter(filter);
        return dialog;
    }

    protected void createPathArrayOption(Composite ancestor, final IProject project, String name, final JsonObject options) {
        Label title = new Label(ancestor, 0);
        title.setText("fill mappings of filename/path.");
        title.setLayoutData((Object)new GridData(768));
        final JsonObject pathsOption = this.getPathsOption(name, options);
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        final TableViewer viewer = new TableViewer(parent, 68354);
        TableViewerColumn filenameColumn = new TableViewerColumn(viewer, 0);
        filenameColumn.getColumn().setWidth(100);
        filenameColumn.getColumn().setResizable(true);
        filenameColumn.getColumn().setText(TernUIMessages.TernModuleOptionsPanel_paths_filenameColumn);
        filenameColumn.setEditingSupport((EditingSupport)new FilenameEditingSupport((ColumnViewer)viewer));
        TableViewerColumn pathColumn = new TableViewerColumn(viewer, 0);
        pathColumn.getColumn().setWidth(180);
        pathColumn.getColumn().setResizable(true);
        pathColumn.getColumn().setText(TernUIMessages.TernModuleOptionsPanel_paths_pathColumn);
        pathColumn.setEditingSupport((EditingSupport)new PathEditingSupport((ColumnViewer)viewer));
        viewer.setLabelProvider((IBaseLabelProvider)JsonLabelProvider.getInstance());
        viewer.setContentProvider((IContentProvider)JsonContentProvider.getInstance());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        viewer.setInput((Object)pathsOption);
        Composite toolbarComposite = new Composite(parent, 0);
        toolbarComposite.setLayout((Layout)new GridLayout());
        toolbarComposite.setLayoutData((Object)new GridData(1808));
        Button addButton = new Button(toolbarComposite, 8);
        addButton.setText("Add..");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenResourceDialog dialog = new OpenResourceDialog(TernModuleOptionsPanel.this.getShell(), true, (IContainer)project, 1);
                if (dialog.open() != 0) {
                    return;
                }
                Object[] results = dialog.getResult();
                if (results != null && results.length > 0) {
                    IFile file = (IFile)results[0];
                    String fileName = this.getPath(file.getName());
                    String path = file.getProjectRelativePath().toString();
                    String base = null;
                    JsonValue baseURL = options.get("baseURL");
                    if (baseURL != null && baseURL.isString()) {
                        base = JsonHelper.getString((JsonValue)baseURL);
                    }
                    if (base != null) {
                        path = file.getProjectRelativePath().makeRelativeTo((IPath)new Path(base)).toString();
                    }
                    path = this.getPath(path);
                    pathsOption.set(fileName, path);
                    viewer.refresh();
                }
            }

            private String getPath(String name) {
                int index = name.lastIndexOf(".");
                if (index != -1) {
                    return name.substring(0, index);
                }
                return name;
            }
        });
        final Button removeButton = new Button(toolbarComposite, 8);
        removeButton.setText("Remove..");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object element : selection) {
                        pathsOption.remove(((MemberWrapper)element).getName());
                    }
                    viewer.refresh();
                    removeButton.setEnabled(false);
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                removeButton.setEnabled(true);
            }
        });
    }

    public JsonObject getPathsOption(String name, JsonObject options) {
        JsonValue pathsOption = options.get(name);
        if (pathsOption == null || !(pathsOption instanceof JsonObject)) {
            pathsOption = new JsonObject();
            options.set(name, pathsOption);
        }
        return (JsonObject)pathsOption;
    }

    protected void createJsonOption(Composite parent, final String name, final JsonObject options) {
        final Text textField = new Text(parent, 2626);
        GridData data = new GridData(768);
        data.heightHint = 100;
        textField.setLayoutData((Object)data);
        String initialValue = JsonHelper.getString((JsonValue)options.get(name));
        textField.setText(initialValue != null ? initialValue : "");
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = textField.getText();
                if (StringUtils.isEmpty((String)value)) {
                    options.remove(name);
                } else {
                    try {
                        options.set(name, (JsonValue)JsonObject.readFrom((String)value));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    public JsonObject getOptions(ITernModuleConfigurable module) {
        JsonObject options = module.getOptions();
        if (options == null) {
            options = new JsonObject();
            module.setOptions(options);
        }
        return options;
    }
}

