/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.controls;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.controls.AbstractTernModulePanel;
import tern.eclipse.ide.internal.ui.controls.DetailsPanel;
import tern.eclipse.ide.ui.viewers.TernModuleLabelProvider;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;
import tern.utils.StringUtils;

public class TernModuleDetailsPanel
extends AbstractTernModulePanel {
    public TernModuleDetailsPanel(Composite parent, ITernModule module, IProject project) {
        super(parent, module, project);
    }

    @Override
    protected void createUI(Composite parent, ITernModule module, IProject project) {
        GridLayout layout = new GridLayout(1, false);
        super.setLayout((Layout)layout);
        this.createHeader(parent, module);
        this.createSeparator();
        this.createBody(module);
    }

    public void createSeparator() {
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    public void createBody(ITernModule module) {
        ScrolledComposite details = new ScrolledComposite((Composite)this, 768);
        details.setLayoutData((Object)new GridData(4, 4, true, true));
        details.setMinWidth(300);
        details.setExpandHorizontal(true);
        details.setExpandVertical(true);
        Composite nestedDetailsComposite = new Composite((Composite)details, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        nestedDetailsComposite.setLayout((Layout)layout);
        details.setContent((Control)nestedDetailsComposite);
        TernModuleMetadata metadata = module.getMetadata();
        if (metadata != null && !StringUtils.isEmpty((String)metadata.getDescription())) {
            Text descTextField = new Text(nestedDetailsComposite, 72);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            descTextField.setLayoutData((Object)data);
            descTextField.setText(metadata.getDescription());
        }
        this.addInfo(nestedDetailsComposite, TernUIMessages.TernModuleDetailsPanel_homepage, null, metadata != null ? metadata.getHomePage() : "", null, true);
        this.addInfo(nestedDetailsComposite, TernUIMessages.TernModuleDetailsPanel_author, null, metadata != null ? metadata.getAuthor() : "", null, false);
        this.addInfo(nestedDetailsComposite, TernUIMessages.TernModuleDetailsPanel_repositoryURL, null, metadata != null ? metadata.getRepositoryURL() : "", null, true);
        this.addInfo(nestedDetailsComposite, TernUIMessages.TernModuleDetailsPanel_bugsURL, null, metadata != null ? metadata.getBugsURL() : "", null, true);
        this.addInfo(nestedDetailsComposite, TernUIMessages.TernModuleDetailsPanel_helpURL, null, metadata != null ? metadata.getHelpURL() : "", null, true);
    }

    public void createHeader(Composite parent, ITernModule module) {
        Composite header = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        header.setLayout((Layout)layout);
        this.addInfo(header, null, TernModuleLabelProvider.getImageModule(module), module.getName(), JFaceResources.getFontRegistry().get(DetailsPanel.HEADER_FONT), false);
    }

    public void addInfo(Composite parent, String valueLabel, Image image, String valueInfo, Font font, boolean hyperlink) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(valueLabel != null ? valueLabel : "");
        if (image != null) {
            label.setImage(image);
        }
        if (hyperlink) {
            Link link = new Link(parent, 64);
            link.setLayoutData((Object)new GridData(768));
            if (link != null) {
                link.setFont(font);
            }
            if (!StringUtils.isEmpty((String)valueInfo)) {
                TernModuleDetailsPanel.setLinkTarget(link, valueInfo);
            }
        } else {
            Text textField = new Text(parent, 72);
            textField.setLayoutData((Object)new GridData(768));
            textField.setText(valueInfo != null ? valueInfo : "");
            if (textField != null) {
                textField.setFont(font);
            }
        }
    }

    private static void setLinkTarget(Link link, final String target) {
        link.setText("<a>" + target + "</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)target);
            }
        });
    }
}

