/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.controls.AbstractTernModulePanel;
import tern.eclipse.ide.ui.viewers.TernModuleLabelProvider;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;
import tern.server.ITernPlugin;

public class TernModuleDependenciesPanel
extends AbstractTernModulePanel {
    public TernModuleDependenciesPanel(Composite parent, ITernModule module, IProject project) {
        super(parent, module, project);
    }

    @Override
    protected void createUI(Composite parent, ITernModule module, IProject project) {
        GridLayout layout = new GridLayout(1, false);
        super.setLayout((Layout)layout);
        Table table = new Table(parent, 68096);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        TableViewerColumn nameColumn = new TableViewerColumn(tableViewer, 0);
        nameColumn.getColumn().setWidth(180);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setText(TernUIMessages.TernModulesBlock_moduleName);
        ArrayList<ITernPlugin> ternModules = new ArrayList<ITernPlugin>();
        TernModuleMetadata metadata = module.getMetadata();
        if (metadata != null) {
            ITernPlugin dependencyModule = null;
            Collection dependencies = metadata.getDependencies();
            for (String dependency : dependencies) {
                dependencyModule = TernCorePlugin.getTernServerTypeManager().findTernPlugin(dependency);
                if (dependencyModule == null) {
                    dependencyModule = TernCorePlugin.getTernServerTypeManager().findTernDef(dependency);
                }
                if (dependencyModule == null) continue;
                ternModules.add(dependencyModule);
            }
        }
        tableViewer.setLabelProvider((IBaseLabelProvider)new TernModuleLabelProvider());
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(ternModules);
    }
}

