/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.libprov;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.libprov.JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSFPortletbridgeRuntimeLibraryProviderInstallOperation
extends LibraryProviderOperation {
    public void execute(LibraryProviderOperationConfig config, IProgressMonitor monitor) throws CoreException {
        IFacetedProjectBase facetedProject = config.getFacetedProject();
        IProject project = facetedProject.getProject();
        JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig portletbridgeConfig = (JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig)config;
        String pbRuntime = portletbridgeConfig.getPortletbridgeHome();
        boolean addRichfacesCapabilities = portletbridgeConfig.isAddRichfacesCapabilities();
        this.getPortletbridgeLibraries(monitor, project, pbRuntime, addRichfacesCapabilities);
        boolean isEPP = portletbridgeConfig.isEPP();
        String richfacesType = portletbridgeConfig.getRichfacesType();
        String richfacesRuntime = portletbridgeConfig.getRichfacesRuntime();
        try {
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)config.getProjectFacet());
            prefs = prefs.node("portletBridgeHome");
            prefs.put("jsfportlet.library.provider/portletbridge_home", pbRuntime);
            prefs.putBoolean("RICHFACES_CAPABILITIES", addRichfacesCapabilities);
            prefs.putBoolean("IS_EPP", isEPP);
            prefs.put("RICHFACES_LIBRARIES_TYPE", richfacesType);
            prefs.put("RICHFACES_RUNTIME", richfacesRuntime);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PortletCoreActivator.log(e);
        }
    }

    private void getPortletbridgeLibraries(IProgressMonitor monitor, IProject project, String pbRuntime, final boolean addRichfacesCapabilities) {
        File pbFolder;
        if (pbRuntime != null && pbRuntime.trim().length() > 0 && (pbFolder = new File(pbRuntime = pbRuntime.trim())).exists() && pbFolder.isDirectory()) {
            String[] fileList = pbFolder.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (!addRichfacesCapabilities && name.contains("richfaces")) {
                        return false;
                    }
                    return name.startsWith("portletbridge") || name.endsWith(".jar");
                }
            });
            ArrayList<File> filesToImport = new ArrayList<File>();
            int i = 0;
            while (i < fileList.length) {
                filesToImport.add(new File(pbRuntime, fileList[i]));
                ++i;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFile libVirtualFile = component.getRootFolder().getFile("WEB-INF/lib");
            IFile folder = libVirtualFile.getUnderlyingFile();
            ImportOperation importOperation = new ImportOperation(folder.getFullPath(), (Object)pbFolder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, PortletCoreActivator.OVERWRITE_ALL_QUERY, filesToImport);
            importOperation.setCreateContainerStructure(false);
            try {
                importOperation.run(monitor);
            }
            catch (Exception e) {
                PortletCoreActivator.log(e, Messages.JSFPortletFacetInstallDelegate_Error_loading_classpath_container);
            }
        }
    }
}

