/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal.project.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.StateManagerType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.portlet.core.JBossWebUtil;
import org.jboss.tools.portlet.core.JBossWebUtil25;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.internal.util.PortletUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFPortletFacetInstallDelegate
implements IDelegate {
    private static final String ORG_JBOSS_PORTLET_STATE_MANAGER = "org.jboss.portletbridge.application.PortletStateManager";
    private static final String ORG_JBOSS_PORTLET_VIEW_HANDLER = "org.jboss.portletbridge.application.PortletViewHandler";
    private static final String COM_SUN_FACELETS_VIEW_HANDLER = "com.sun.facelets.FaceletViewHandler";

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg == null) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.JSFPortletFacetInstallDelegate_Missing_configuration));
            }
            config = (IDataModel)cfg;
            IModelProvider provider = PortletCoreActivator.getModelProvider(project);
            if (provider == null) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.JSFPortletFacetInstallDelegate_Cannot_configure_web_module_for_JBoss_JSF_Portlet_Facet));
            }
            if (!provider.validateEdit(null, null).isOK() && !provider.validateEdit(null, null).isOK()) {
                throw new CoreException(PortletCoreActivator.getStatus(Messages.JSFPortletFacetInstallDelegate_The_web_xml_file_is_not_updateable));
            }
            ((LibraryInstallDelegate)config.getProperty("JSFPORTLET_LIBRARY_PROVIDER_DELEGATE")).execute(monitor);
            this.configureFacesConfig(project, monitor, config, fv);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void configureFacesConfig(IProject project, IProgressMonitor monitor, IDataModel config, IProjectFacetVersion fv) {
        FacesConfigType facesConfig;
        FacesConfigArtifactEdit facesConfigEdit;
        int version = PortletUtil.getPortletBridgeVersion(project);
        if (version >= 3) {
            return;
        }
        String facesConfigString = this.getFacesConfigFile(project, monitor);
        if (facesConfigString == null || facesConfigString.trim().length() <= 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(facesConfigString, ",");
        ArrayList<String> facesConfigs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            facesConfigs.add(tokenizer.nextToken().trim());
        }
        FacesState state = this.checkState(project, facesConfigs);
        if (state.applicationExists && state.viewHandlerExists && state.stateManagerExists) {
            return;
        }
        if (!state.applicationExists) {
            facesConfigEdit = null;
            try {
                facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)((String)facesConfigs.get(0)));
                facesConfig = facesConfigEdit.getFacesConfig();
                if (facesConfig != null) {
                    facesConfig.getApplication();
                    ApplicationType application = FacesConfigFactory.eINSTANCE.createApplicationType();
                    state.application = application;
                    state.facesConfigString = (String)facesConfigs.get(0);
                    facesConfig.getApplication().add((Object)application);
                    facesConfigEdit.save(monitor);
                }
            }
            finally {
                if (facesConfigEdit != null) {
                    facesConfigEdit.dispose();
                }
            }
        }
        facesConfigEdit = null;
        try {
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)state.facesConfigString);
            facesConfig = facesConfigEdit.getFacesConfig();
            if (facesConfig != null) {
                if (!state.viewHandlerExists) {
                    ViewHandlerType viewHandler = FacesConfigFactory.eINSTANCE.createViewHandlerType();
                    viewHandler.setTextContent(ORG_JBOSS_PORTLET_VIEW_HANDLER);
                    state.application.getViewHandler().add((Object)viewHandler);
                }
                if (!state.stateManagerExists) {
                    StateManagerType stateManager = FacesConfigFactory.eINSTANCE.createStateManagerType();
                    stateManager.setTextContent(ORG_JBOSS_PORTLET_STATE_MANAGER);
                    state.application.getStateManager().add((Object)stateManager);
                }
                facesConfigEdit.save(monitor);
            }
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
            }
        }
    }

    private FacesState checkState(IProject project, List<String> facesConfigs) {
        FacesState facesState = new FacesState();
        for (String facesConfigString : facesConfigs) {
            FacesConfigArtifactEdit facesConfigEdit = null;
            try {
                EList applications;
                facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)facesConfigString);
                FacesConfigType facesConfig = facesConfigEdit.getFacesConfig();
                if (facesConfig == null || (applications = facesConfig.getApplication()).size() <= 0) continue;
                facesState.applicationExists = true;
                facesState.application = (ApplicationType)applications.get(0);
                facesState.facesConfigString = facesConfigString;
                for (ApplicationType application : applications) {
                    EList viewHandlers = application.getViewHandler();
                    ViewHandlerType faceletsHandler = null;
                    for (ViewHandlerType viewHandler : viewHandlers) {
                        if (ORG_JBOSS_PORTLET_VIEW_HANDLER.equals(viewHandler.getTextContent())) {
                            facesState.viewHandlerExists = true;
                        }
                        if (!COM_SUN_FACELETS_VIEW_HANDLER.equals(viewHandler.getTextContent())) continue;
                        faceletsHandler = viewHandler;
                    }
                    if (faceletsHandler == null) continue;
                    viewHandlers.remove(faceletsHandler);
                }
                for (ApplicationType application : applications) {
                    EList stateManagers = application.getStateManager();
                    for (StateManagerType stateManager : stateManagers) {
                        if (!ORG_JBOSS_PORTLET_STATE_MANAGER.equals(stateManager.getTextContent())) continue;
                        facesState.stateManagerExists = true;
                    }
                }
                if (!facesState.applicationExists || !facesState.viewHandlerExists || !facesState.stateManagerExists) continue;
                break;
            }
            finally {
                if (facesConfigEdit != null) {
                    facesConfigEdit.dispose();
                }
            }
        }
        return facesState;
    }

    private String getFacesConfigFile(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = PortletCoreActivator.getModelProvider(project);
        if (PortletCoreActivator.isWebApp25(provider.getModelObject())) {
            return new JBossWebUtil25().getFacesConfig(project, monitor);
        }
        return new JBossWebUtil().getFacesConfig(project, monitor);
    }

    private class FacesState {
        private boolean applicationExists = false;
        private boolean viewHandlerExists = false;
        private boolean stateManagerExists = false;
        private ApplicationType application = null;
        private String facesConfigString = null;

        private FacesState() {
        }
    }
}

