/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.DispatcherType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.jboss.tools.portlet.core.IJBossWebUtil;
import org.jboss.tools.portlet.core.PortletCoreActivator;

public class JBossWebUtil25
implements IJBossWebUtil {
    public void configureContextParam(IProject project, IProgressMonitor monitor, String name, String value, String description) {
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return;
        }
        IOverwriteQuery query = PortletCoreActivator.OVERWRITE_ALL_QUERY;
        List list = webApp.getContextParams();
        int index = this.getContextParamIndexByName(list, name);
        if (index >= 0) {
            String ret = query.queryOverwrite("Context-param '" + name + "'");
            if ("NO".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            if ("CANCEL".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            list.remove(index);
        }
        ParamValue param = JavaeeFactory.eINSTANCE.createParamValue();
        param.setParamName(name);
        param.setParamValue(value);
        if (description != null) {
            Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
            descriptionObj.setValue(description);
            param.getDescriptions().add(descriptionObj);
        }
        webApp.getContextParams().add(param);
    }

    private int getContextParamIndexByName(List list, String name) {
        if (list == null || name == null) {
            return -1;
        }
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            ParamValue param;
            Object paramObj = it.next();
            if (paramObj instanceof ParamValue && name.equals((param = (ParamValue)paramObj).getParamName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void configureFilter(IProject project, IProgressMonitor monitor, String name, String className, String displayName, String description) {
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return;
        }
        IOverwriteQuery query = PortletCoreActivator.OVERWRITE_ALL_QUERY;
        Object obj = this.getFilterByName(webApp, name);
        if (obj != null) {
            String ret = query.queryOverwrite("Filter '" + name + "'");
            if ("NO".equalsIgnoreCase(ret) || "CANCEL".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            webApp.getFilters().remove(obj);
        }
        Filter filter = WebFactory.eINSTANCE.createFilter();
        filter.setFilterName(name);
        filter.setFilterClass(className);
        DisplayName dName = JavaeeFactory.eINSTANCE.createDisplayName();
        dName.setValue(displayName);
        filter.getDisplayNames().add(dName);
        Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
        descriptionObj.setValue(description);
        webApp.getFilters().add(filter);
    }

    private Object getFilterByName(WebApp webApp, String name) {
        if (webApp == null || name == null) {
            return null;
        }
        List filters = webApp.getFilters();
        for (Filter filter : filters) {
            if (filter == null || !name.equals(filter.getFilterName())) continue;
            return filter;
        }
        return null;
    }

    public void configureFilterMapping(IProject project, IProgressMonitor monitor, String name, String servletName) {
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return;
        }
        IOverwriteQuery query = PortletCoreActivator.OVERWRITE_ALL_QUERY;
        Object obj = this.getFilterMappingByKey(webApp.getFilterMappings(), name);
        if (obj != null) {
            String ret = query.queryOverwrite("Filter-mapping '" + name + "'");
            if ("NO".equalsIgnoreCase(ret) || "CANCEL".equalsIgnoreCase(ret)) {
                monitor.setCanceled(true);
                return;
            }
            webApp.getFilterMappings().remove(obj);
        }
        FilterMapping mapping = WebFactory.eINSTANCE.createFilterMapping();
        Filter filter = (Filter)this.getFilterByName(webApp, name);
        if (filter != null) {
            mapping.setFilterName(filter.getFilterName());
            mapping.getDispatchers().add(DispatcherType.REQUEST_LITERAL);
            mapping.getDispatchers().add(DispatcherType.FORWARD_LITERAL);
            mapping.getDispatchers().add(DispatcherType.INCLUDE_LITERAL);
            mapping.getServletNames().add(servletName);
            webApp.getFilterMappings().add(mapping);
        }
    }

    private Object getFilterMappingByKey(List list, String key) {
        if (list == null || key == null) {
            return null;
        }
        for (FilterMapping filterMapping : list) {
            if (filterMapping == null) continue;
            String name = filterMapping.getFilterName();
            List servletNames = filterMapping.getServletNames();
            for (String servletName : servletNames) {
                List urlPatterns = filterMapping.getUrlPatterns();
                for (UrlPatternType urlPattern : urlPatterns) {
                    String uri = urlPattern.getValue();
                    String curKey = this.getFilterMappingString(name, servletName, uri);
                    if (!key.equals(curKey)) continue;
                    return filterMapping;
                }
            }
        }
        return null;
    }

    private String getFilterMappingString(String name, String servletName, String uri) {
        return String.valueOf(name != null ? name : "") + (servletName != null ? servletName : "") + (uri != null ? uri : "");
    }

    private Servlet findServletByName(WebApp webApp, String name) {
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet.getServletName() == null || !servlet.getServletName().trim().equals(name)) continue;
            return servlet;
        }
        return null;
    }

    private WebApp getWebApp(IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (project == null) {
            return null;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return null;
        }
        WebApp webApp = (WebApp)modelObject;
        return webApp;
    }

    public String findJsfServlet(Object modelObject) {
        WebApp webApp = (WebApp)modelObject;
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet.getServletClass() == null || !servlet.getServletClass().trim().equals(JSF_SERVLET_CLASS)) continue;
            return servlet.getServletName();
        }
        return null;
    }

    public String getFacesConfig(IProject project, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(project, monitor);
        if (webApp == null) {
            return null;
        }
        List contextParams = webApp.getContextParams();
        for (Object paramObj : contextParams) {
            ParamValue param;
            if (!(paramObj instanceof ParamValue) || !"javax.faces.CONFIG_FILES".equals((param = (ParamValue)paramObj).getParamName())) continue;
            return param.getParamValue();
        }
        return "/WEB-INF/faces-config.xml";
    }
}

