/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.client.internal.log;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.openshift.express.client.internal.log.Trace;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends AppenderSkeleton {
    private static final String OPENSHIFT_CLIENT_BUNDLE = "org.jboss.tools.openshift.express.client";
    private static final String OPENSHIFT_CLIENT_TRACE = "/client";
    private ILog log;
    private Trace trace = new Trace("org.jboss.tools.openshift.express.client");

    protected void append(LoggingEvent event) {
        this.trace(event);
    }

    private void trace(LoggingEvent event) {
        if (this.trace.isDebugging()) {
            this.trace.trace(OPENSHIFT_CLIENT_TRACE, String.valueOf(event.getMessage()));
        }
    }

    private void log(LoggingEvent event) {
        String logString = this.layout.format(event);
        ILog myLog = this.getLog();
        if (myLog != null) {
            String loggerName = event.getLoggerName();
            int severity = this.mapLevel(event.getLevel());
            Throwable throwable = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
            IStatus status = this.createStatus(severity, loggerName, logString, throwable);
            this.getLog().log(status);
        }
    }

    private int mapLevel(Level level) {
        switch (level.toInt()) {
            case 10000: 
            case 20000: {
                return 1;
            }
            case 30000: {
                return 2;
            }
            case 40000: 
            case 50000: {
                return 4;
            }
        }
        return 1;
    }

    private ILog getLog() {
        if (this.log == null) {
            this.log = Platform.getLog((Bundle)Platform.getBundle((String)OPENSHIFT_CLIENT_BUNDLE));
        }
        return this.log;
    }

    private IStatus createStatus(int severity, String loggerName, String message, Throwable throwable) {
        return new Status(severity, OPENSHIFT_CLIENT_BUNDLE, message, throwable);
    }

    public void close() {
        this.trace.close();
    }

    public boolean requiresLayout() {
        return true;
    }
}

