/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.view;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.PreferenceSettingStore;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.ssh.SshConnector;
import org.eclipse.tm.internal.terminal.ssh.SshSettings;
import org.eclipse.tm.internal.terminal.view.TerminalView;
import org.eclipse.ui.IViewPart;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.server.view.ITerminalConnectionListener;
import org.fusesource.ide.server.view.ServerViewPlugin;

public class SshView
extends TerminalView {
    private static final int MAX_RETRIES = 3;
    private static final int DELAY = 5000;
    private List<ITerminalConnectionListener> connectionListeners = new LinkedList<ITerminalConnectionListener>();
    private SshConnector sshc;
    private boolean connected = false;

    public void addConnectionListener(ITerminalConnectionListener listener) {
        if (!this.connectionListeners.contains(listener)) {
            this.connectionListeners.add(listener);
        }
    }

    public void removeConnectionListener(ITerminalConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void setPartName(String partName) {
        super.setPartName("Shell");
    }

    public void createConnectionIfNotExists(String host, int port, String user, String pass) throws Exception {
        IViewPart vp = ServerViewPlugin.openTerminalView();
        if (vp == null || !(vp instanceof TerminalView)) {
            ServerViewPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        TerminalView connectorView = (TerminalView)vp;
        ITerminalConnector conn = TerminalConnectorExtension.makeTerminalConnector((String)"org.eclipse.tm.internal.terminal.ssh.SshConnector");
        if (conn != null) {
            conn.makeSettingsPage();
            this.sshc = (SshConnector)conn.getAdapter(SshConnector.class);
            if (this.sshc != null) {
                SshSettings settings = (SshSettings)this.sshc.getSshSettings();
                settings.setHost(host);
                if (user != null) {
                    settings.setUser(user);
                }
                if (pass != null) {
                    settings.setPassword(pass);
                }
                settings.setPort("" + port);
                settings.setKeepalive("300");
                settings.setTimeout("45");
                try {
                    Method mGetStore = Objects.getMethodDescriptor((Object)connectorView, (String)"getPreferenceSettingsStore", TerminalView.class, null);
                    PreferenceSettingStore store = (PreferenceSettingStore)mGetStore.invoke((Object)connectorView, null);
                    Method mSave = Objects.getMethodDescriptor((Object)connectorView, (String)"saveSettings", TerminalView.class, (Class[])new Class[]{ISettingsStore.class, ITerminalConnector.class});
                    mSave.invoke((Object)connectorView, store, conn);
                    Method mSetCon = Objects.getMethodDescriptor((Object)connectorView, (String)"setConnector", TerminalView.class, (Class[])new Class[]{ITerminalConnector.class});
                    mSetCon.invoke((Object)connectorView, conn);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int cnt = 0;
                                while (SshView.this.sshc.getInputStream() == null && cnt < 3) {
                                    SshView.this.onTerminalConnect();
                                    if (SshView.this.sshc.getInputStream() != null) continue;
                                    try {
                                        try {
                                            Thread.sleep(5000L);
                                        }
                                        catch (InterruptedException e) {
                                            ServerViewPlugin.getLogger().error((Throwable)e);
                                            ++cnt;
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        ++cnt;
                                        throw throwable;
                                    }
                                    ++cnt;
                                }
                            }
                            catch (Exception ex) {
                                ServerViewPlugin.getLogger().error((Throwable)ex);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    ServerViewPlugin.getLogger().error((Throwable)ex);
                }
            }
        }
    }

    public void updateStatus() {
        super.updateStatus();
        if (this.connected && !this.fCtlTerminal.isConnected()) {
            this.onTerminalDisconnect();
        }
        this.connected = this.fCtlTerminal.isConnected();
    }

    public void onTerminalConnect() {
        super.onTerminalConnect();
        this.fireOnConnect();
    }

    public void onTerminalDisconnect() {
        try {
            if (this.connected && this.fCtlTerminal.isConnected()) {
                super.onTerminalDisconnect();
                this.fireOnDisconnect();
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SshView.this.fActionEditClearAll.run();
                }
            });
        }
        catch (Exception ex) {
            ServerViewPlugin.getLogger().error("Problem occured while disconnecting from SSH terminal...", (Throwable)ex);
        }
    }

    private void fireOnConnect() {
        for (ITerminalConnectionListener l : this.connectionListeners) {
            l.onConnect();
        }
    }

    private void fireOnDisconnect() {
        for (ITerminalConnectionListener l : this.connectionListeners) {
            l.onDisconnect();
        }
    }
}

