/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.view;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.osgi.framework.BundleContext;

public class ServerViewPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.fusesource.ide.server.view";
    public static final String TERMINAL_VIEW_ID = "org.fusesource.ide.server.view.TerminalView";
    private static ServerViewPlugin plugin;
    private static IViewPart part;

    public static ServerViewPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static IViewPart openTerminalView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (activeWindow = wb.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        part = activePage.showView(ServerViewPlugin.TERMINAL_VIEW_ID);
                    }
                    catch (CoreException ex) {
                        ServerViewPlugin.getLogger().error("Unable to create the terminal view!", (Throwable)ex);
                    }
                }
            }
        });
        return part;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)ServerViewPlugin.getDefault().getLog());
    }
}

