/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;
import org.fusesource.ide.commons.properties.EnumPropertyDescriptor;

public class Sampling
extends AbstractNode {
    public static final String PROPERTY_INHERITERRORHANDLER = "Sampling.InheritErrorHandler";
    public static final String PROPERTY_SAMPLEPERIOD = "Sampling.SamplePeriod";
    public static final String PROPERTY_MESSAGEFREQUENCY = "Sampling.MessageFrequency";
    public static final String PROPERTY_UNITS = "Sampling.Units";
    private Boolean inheritErrorHandler;
    private Long samplePeriod;
    private Long messageFrequency;
    private TimeUnit units;

    public Sampling() {
    }

    public Sampling(SamplingDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "samplingNode";
    }

    @Override
    public String getCategoryName() {
        return "Miscellaneous";
    }

    @Override
    public Boolean getInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    @Override
    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        Boolean oldValue = this.inheritErrorHandler;
        this.inheritErrorHandler = inheritErrorHandler;
        if (!this.isSame(oldValue, inheritErrorHandler)) {
            this.firePropertyChange(PROPERTY_INHERITERRORHANDLER, oldValue, inheritErrorHandler);
        }
    }

    public Long getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(Long samplePeriod) {
        Long oldValue = this.samplePeriod;
        this.samplePeriod = samplePeriod;
        if (!this.isSame(oldValue, samplePeriod)) {
            this.firePropertyChange(PROPERTY_SAMPLEPERIOD, oldValue, samplePeriod);
        }
    }

    public Long getMessageFrequency() {
        return this.messageFrequency;
    }

    public void setMessageFrequency(Long messageFrequency) {
        Long oldValue = this.messageFrequency;
        this.messageFrequency = messageFrequency;
        if (!this.isSame(oldValue, messageFrequency)) {
            this.firePropertyChange(PROPERTY_MESSAGEFREQUENCY, oldValue, messageFrequency);
        }
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    public void setUnits(TimeUnit units) {
        TimeUnit oldValue = this.units;
        this.units = units;
        if (!this.isSame((Object)oldValue, (Object)units)) {
            this.firePropertyChange(PROPERTY_UNITS, (Object)oldValue, (Object)units);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        BooleanPropertyDescriptor descInheritErrorHandler = new BooleanPropertyDescriptor((Object)PROPERTY_INHERITERRORHANDLER, Messages.propertyLabelSamplingInheritErrorHandler);
        TextPropertyDescriptor descSamplePeriod = new TextPropertyDescriptor((Object)PROPERTY_SAMPLEPERIOD, Messages.propertyLabelSamplingSamplePeriod);
        TextPropertyDescriptor descMessageFrequency = new TextPropertyDescriptor((Object)PROPERTY_MESSAGEFREQUENCY, Messages.propertyLabelSamplingMessageFrequency);
        EnumPropertyDescriptor descUnits = new EnumPropertyDescriptor((Object)PROPERTY_UNITS, Messages.propertyLabelSamplingUnits, TimeUnit.class);
        descriptors.put(PROPERTY_INHERITERRORHANDLER, (PropertyDescriptor)descInheritErrorHandler);
        descriptors.put(PROPERTY_SAMPLEPERIOD, (PropertyDescriptor)descSamplePeriod);
        descriptors.put(PROPERTY_MESSAGEFREQUENCY, (PropertyDescriptor)descMessageFrequency);
        descriptors.put(PROPERTY_UNITS, (PropertyDescriptor)descUnits);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_INHERITERRORHANDLER.equals(id)) {
            this.setInheritErrorHandler(Objects.convertTo(value, Boolean.class));
        } else if (PROPERTY_SAMPLEPERIOD.equals(id)) {
            this.setSamplePeriod(Objects.convertTo(value, Long.class));
        } else if (PROPERTY_MESSAGEFREQUENCY.equals(id)) {
            this.setMessageFrequency(Objects.convertTo(value, Long.class));
        } else if (PROPERTY_UNITS.equals(id)) {
            this.setUnits(Objects.convertTo(value, TimeUnit.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_INHERITERRORHANDLER.equals(id)) {
            return Objects.getField(this, "inheritErrorHandler");
        }
        if (PROPERTY_SAMPLEPERIOD.equals(id)) {
            return this.getSamplePeriod();
        }
        if (PROPERTY_MESSAGEFREQUENCY.equals(id)) {
            return this.getMessageFrequency();
        }
        if (PROPERTY_UNITS.equals(id)) {
            return this.getUnits();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        SamplingDefinition answer = new SamplingDefinition();
        answer.setInheritErrorHandler(this.toXmlPropertyValue(PROPERTY_INHERITERRORHANDLER, (Boolean)Objects.getField(this, "inheritErrorHandler")));
        answer.setSamplePeriod(this.toXmlPropertyValue(PROPERTY_SAMPLEPERIOD, this.getSamplePeriod()));
        answer.setMessageFrequency(this.toXmlPropertyValue(PROPERTY_MESSAGEFREQUENCY, this.getMessageFrequency()));
        answer.setUnits(this.toXmlPropertyValue(PROPERTY_UNITS, this.getUnits()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return SamplingDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof SamplingDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof SamplingDefinition. Was " + processor.getClass().getName());
        }
        SamplingDefinition node = (SamplingDefinition)processor;
        this.setInheritErrorHandler((Boolean)Objects.getField(node, "inheritErrorHandler"));
        this.setSamplePeriod(node.getSamplePeriod());
        this.setMessageFrequency(node.getMessageFrequency());
        this.setUnits(node.getUnits());
    }
}

