/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model;

import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ToDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.CamelModelHelper;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.generated.Messages;

public class Endpoint
extends AbstractNode {
    public static final String PROPERTY_URI = "Endpoint.Uri";
    private static final String ICON = "endpoint.png";
    private String uri = "";

    public Endpoint() {
    }

    public static Endpoint newInstance(ToDefinition definition, RouteContainer parent) {
        if (parent instanceof RouteSupport) {
            RouteSupport route = (RouteSupport)parent;
            return route.getOrCreateEndpoint(definition, parent);
        }
        return new Endpoint(definition, parent);
    }

    public Endpoint(ToDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    public Endpoint(FromDefinition definition, RouteContainer parent) {
        super(parent);
        this.setId(definition.getId());
        this.setDescription(definition.getDescriptionText());
        this.setUri(CamelModelHelper.getUri(definition));
    }

    public Endpoint(String uri) {
        this.uri = uri;
    }

    public Endpoint(Endpoint endpoint) {
        this(endpoint.uri);
        this.setId(endpoint.getId());
        this.setDescription(endpoint.getDescription());
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        String oldUri = this.uri;
        this.uri = uri;
        if (!this.isSame(uri, oldUri)) {
            this.clearImages();
            this.firePropertyChange(PROPERTY_URI, oldUri, uri);
        }
    }

    @Override
    public String getIconName() {
        String u = this.getUri();
        if (u != null) {
            if (u.startsWith("drools:")) {
                return "endpointDrools.png";
            }
            if (u.startsWith("jms") || u.startsWith("activemq") || u.startsWith("mq") || u.startsWith("sjms")) {
                return "endpointQueue.png";
            }
            if (u.startsWith("file") || u.startsWith("ftp") || u.startsWith("sftp") || u.startsWith("jcr") || u.startsWith("scp")) {
                return "endpointFolder.png";
            }
            if (u.startsWith("log") || u.startsWith("hdfs") || u.startsWith("paxlogging")) {
                return "endpointFile.png";
            }
            if (u.startsWith("timer") || u.startsWith("quartz")) {
                return "endpointTimer.png";
            }
            if (u.startsWith("elasticsearch") || u.startsWith("hazelcast") || u.startsWith("hibernate") || u.startsWith("jpa") || u.startsWith("jdbc") || u.startsWith("sql") || u.startsWith("ibatis") || u.startsWith("mybatis") || u.startsWith("javaspace") || u.startsWith("jcr") || u.startsWith("ldap") || u.startsWith("mongodb") || u.startsWith("zookeeper")) {
                return "endpointRepository.png";
            }
        }
        return ICON;
    }

    @Override
    public String getDocumentationFileName() {
        return "endpoint";
    }

    @Override
    public String getCategoryName() {
        return "Endpoints";
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor desc = new TextPropertyDescriptor((Object)PROPERTY_URI, Messages.propertyLabelEndpointUri);
        desc.setValidator(DEFAULT_STRING_VALIDATOR);
        descriptors.put(PROPERTY_URI, (PropertyDescriptor)desc);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_URI.equals(id)) {
            this.setUri((String)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_URI.equals(id)) {
            return this.getUri();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        ToDefinition answer = new ToDefinition();
        CamelModelHelper.setUri(answer, this);
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public void savePropertiesToCamelDefinition(ProcessorDefinition processor) {
        super.savePropertiesToCamelDefinition(processor);
        if (!(processor instanceof ToDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ToDefinition. Was " + processor.getClass().getName());
        }
        ToDefinition node = (ToDefinition)processor;
        CamelModelHelper.setUri(node, this);
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof ToDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ToDefinition. Was " + processor.getClass().getName());
        }
        ToDefinition node = (ToDefinition)processor;
        String value = CamelModelHelper.getUri(node);
        this.setUri(value);
    }

    public void populateCamelDefinition(FromDefinition from) {
        this.setId(from.getId());
        this.setDescription(from.getDescriptionText());
    }

    @Override
    public void appendEndpointUris(Set<String> uris) {
        String trimmed;
        if (this.uri != null && (trimmed = this.uri.trim()).length() > 0) {
            uris.add(trimmed);
        }
        super.appendEndpointUris(uris);
    }

    public boolean isInputEndpoint() {
        return !this.getSourceConnections().isEmpty() && this.getTargetConnections().isEmpty();
    }

    public boolean isOutputEndpoint() {
        return this.getSourceConnections().isEmpty() && !this.getTargetConnections().isEmpty();
    }
}

