/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.TopicViewFacade;
import java.util.Collection;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.activemq.Messages;
import org.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import org.fusesource.ide.fabric.activemq.navigator.TopicNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public TopicsNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Topics";
    }

    protected void loadChildren() {
        try {
            Collection topics = this.facade.getTopics();
            if (topics != null) {
                for (TopicViewFacade topic : topics) {
                    this.addChild((Node)new TopicNode(this, (TopicViewMBean)topic));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("topic.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action createTopicAction = new Action(Messages.CreateTopicAction, 32){

            public void run() {
                TopicsNode.this.showCreateTopicDialog();
            }
        };
        createTopicAction.setToolTipText(Messages.CreateTopicActionToolTip);
        createTopicAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("new_topic.png"));
        menu.add((IAction)createTopicAction);
    }

    protected void showCreateTopicDialog() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateTopicDialogTitle, Messages.CreateTopicDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String topic = dialog.getValue();
            this.createTopic(topic);
        }
    }

    protected void createTopic(String topic) {
        if (!Strings.isBlank((String)topic)) {
            try {
                this.getFacade().getBrokerAdmin().addTopic(topic);
                this.refresh();
            }
            catch (Exception e) {
                FabricPlugin.showUserError((String)"Failed to create Topic", (String)("Failed to create topic: " + topic), (Exception)e);
            }
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

