/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.DurableSubscriptionViewFacade;
import java.util.Collection;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import org.fusesource.ide.fabric.activemq.navigator.SubscriptionNode;
import org.fusesource.ide.fabric.activemq.navigator.TopicNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicDurableConsumersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final TopicNode queueNode;

    public TopicDurableConsumersNode(TopicNode queueNode) {
        super((Node)queueNode);
        this.queueNode = queueNode;
        this.brokerNode = queueNode.getBrokerNode();
        this.facade = queueNode.getFacade();
    }

    public String toString() {
        return "Durable Consumers";
    }

    protected void loadChildren() {
        try {
            Collection list = this.getFacade().getTopicDurableConsumers(this.queueNode.getName());
            if (list != null) {
                for (DurableSubscriptionViewFacade mbean : list) {
                    this.addChild((Node)new SubscriptionNode((Node)this, (SubscriptionViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/listeners.gif");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

