/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IExchangeBrowser;
import org.fusesource.ide.commons.tree.ConnectedNode;
import org.fusesource.ide.commons.tree.GraphableNode;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.activemq.ActiveMQConverter;
import org.fusesource.ide.fabric.activemq.FabricActiveMQPlugin;
import org.fusesource.ide.fabric.activemq.Messages;
import org.fusesource.ide.fabric.activemq.navigator.DestinationNodeSupport;
import org.fusesource.ide.fabric.activemq.navigator.QueueConsumersNode;
import org.fusesource.ide.fabric.activemq.navigator.QueueProducersNode;
import org.fusesource.ide.fabric.activemq.navigator.QueuesNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class QueueNode
extends DestinationNodeSupport
implements IExchangeBrowser,
ImageProvider,
ContextMenuProvider,
IPropertySourceProvider,
GraphableNode,
ConnectedNode {
    private final QueuesNode queuesNode;
    private final QueueViewMBean queue;
    private final QueueConsumersNode consumersNode;
    private final QueueProducersNode producersNode;
    private ActiveMQConverter converter = new ActiveMQConverter();

    public QueueNode(QueuesNode queuesNode, QueueViewMBean queue) {
        super((Node)queuesNode, queuesNode.getBrokerNode(), (DestinationViewMBean)queue);
        this.queuesNode = queuesNode;
        this.queue = queue;
        this.consumersNode = new QueueConsumersNode(this);
        this.addChild((Node)this.consumersNode);
        this.producersNode = new QueueProducersNode(this);
        this.addChild((Node)this.producersNode);
        this.setPropertyBean(queue);
    }

    public QueuesNode getQueuesNode() {
        return this.queuesNode;
    }

    public QueueViewMBean getQueue() {
        return this.queue;
    }

    public List<Node> getChildrenGraph() {
        ArrayList<Node> answer = new ArrayList<Node>();
        answer.addAll(Arrays.asList(this.consumersNode.getChildren()));
        answer.addAll(Arrays.asList(this.producersNode.getChildren()));
        return answer;
    }

    public List<?> getConnectedTo() {
        return this.getConsumersNode().getChildrenList();
    }

    public QueueConsumersNode getConsumersNode() {
        return this.consumersNode;
    }

    public QueueProducersNode getProducersNode() {
        return this.producersNode;
    }

    public List<IExchange> browseExchanges() {
        ArrayList<IExchange> answer = new ArrayList<IExchange>();
        try {
            CompositeData[] cds = this.queue.browse();
            if (cds != null) {
                CompositeData[] compositeDataArray = cds;
                int n = cds.length;
                int n2 = 0;
                while (n2 < n) {
                    CompositeData cd = compositeDataArray[n2];
                    IExchange exchange = this.converter.toExchange(cd);
                    if (exchange != null) {
                        answer.add(exchange);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            FabricActiveMQPlugin.getLogger().warning("Failed to browse queue " + e, (Throwable)e);
        }
        return answer;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("queue.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action deleteQueueAction = new Action(Messages.DeleteQueueAction, 32){

            public void run() {
                QueueNode.this.showDeleteQueueDialog();
            }
        };
        deleteQueueAction.setToolTipText(Messages.DeleteQueueActionToolTip);
        deleteQueueAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("delete.gif"));
        menu.add((IAction)deleteQueueAction);
    }

    protected void showDeleteQueueDialog() {
        String message = Messages.bind((String)Messages.DeleteQueueDialogMessage, (Object)this.queue.getName());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.DeleteQueueDialogTitle, (String)message);
        if (confirm) {
            this.deleteQueue();
        }
    }

    protected void deleteQueue() {
        String name = this.queue.getName();
        try {
            this.getFacade().getBrokerAdmin().removeQueue(name);
            this.queuesNode.refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to delete Queue", (String)("Failed to delete queue: " + this.queue), (Exception)e);
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

