/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.ConnectionViewFacade;
import java.util.Collection;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import org.fusesource.ide.fabric.activemq.navigator.ConnectionNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ConnectionsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public ConnectionsNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Connections";
    }

    protected void loadChildren() {
        try {
            Collection list = this.facade.getConnections();
            if (list != null) {
                for (ConnectionViewFacade mbean : list) {
                    this.addChild((Node)new ConnectionNode((Node)this, (ConnectionViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("connection_folder.png");
    }

    public void provideContextMenu(IMenuManager menu) {
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

