/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.JmxTemplateBrokerFacade;
import io.fabric8.activemq.facade.RemoteBrokerFacade;
import java.util.List;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.CoreException;
import org.fusesource.ide.fabric.activemq.FabricActiveMQPlugin;
import org.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import org.fusesource.ide.fabric.navigator.ContainerNode;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.NodeProvider;
import org.jboss.tools.jmx.core.tree.Root;

public class ActiveMQNodeProvider
implements org.fusesource.ide.fabric.navigator.NodeProvider,
NodeProvider {
    public void provide(ContainerNode agentNode) {
        JmxTemplateBrokerFacade facade = new JmxTemplateBrokerFacade(agentNode.getJmxTemplate());
        String brokerName = null;
        try {
            brokerName = facade.getBrokerName();
        }
        catch (Exception e) {
            FabricActiveMQPlugin.getLogger().warning("Could not find Broker name: " + e, (Throwable)e);
        }
        if (brokerName == null) {
            brokerName = "Broker";
        }
        agentNode.addChild((Node)new BrokerNode((Node)agentNode, (BrokerFacade)facade, brokerName));
    }

    public void provide(final Root root) {
        if (root.containsDomain("org.apache.activemq")) {
            try {
                root.getConnection().run(new IJMXRunnable(){

                    public void run(MBeanServerConnection connection) throws JMXException {
                        RemoteBrokerFacade facade = new RemoteBrokerFacade(connection);
                        BrokerNode broker = new BrokerNode((Node)root, (BrokerFacade)facade, "Broker");
                        root.addChild((Node)broker);
                    }
                });
            }
            catch (CoreException e) {
                FabricActiveMQPlugin.getLogger().warning("Failed to connect to JMX: " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    public void provideRootNodes(List<NodeProvider> list) {
    }
}

