/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric.activemq;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ILog;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.commons.ui.ImagesActivatorSupport;
import org.fusesource.ide.fabric.FabricPlugin;
import org.fusesource.ide.fabric.activemq.ActiveMQConverter;
import org.fusesource.ide.fabric.activemq.navigator.ActiveMQNodeProvider;
import org.fusesource.ide.fabric.activemq.navigator.ActiveMQPreferenceInitializer;
import org.fusesource.ide.fabric.navigator.NodeProvider;
import org.osgi.framework.BundleContext;

public class FabricActiveMQPlugin
extends ImagesActivatorSupport {
    private static FabricActiveMQPlugin plugin;
    private static ActiveMQNodeProvider nodeProvider;
    private static ActiveMQConverter converter;
    private static AtomicBoolean started;

    static {
        started = new AtomicBoolean(false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public static void registerNodeProviders() {
        if (started.compareAndSet(false, true)) {
            new ActiveMQPreferenceInitializer().initializeDefaultPreferences();
            nodeProvider = new ActiveMQNodeProvider();
            FabricPlugin.addNodeProvider((NodeProvider)nodeProvider);
        }
    }

    public void stop(BundleContext context) throws Exception {
        FabricPlugin.removeNodeProvider((NodeProvider)nodeProvider);
        plugin = null;
        super.stop(context);
    }

    public static FabricActiveMQPlugin getDefault() {
        return plugin;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)FabricActiveMQPlugin.getDefault().getLog());
    }

    public static ActiveMQConverter getConverter() {
        if (converter == null) {
            converter = new ActiveMQConverter();
        }
        return converter;
    }

    public static void setConverter(ActiveMQConverter converter) {
        FabricActiveMQPlugin.converter = converter;
    }
}

