/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.util.HashSet;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;

public class ValidIdConstraint
extends AbstractModelConstraint {
    protected static HashSet<EClass> idOptional = new HashSet();

    static {
        idOptional.add(Bpmn2Package.eINSTANCE.getDefinitions());
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (!idOptional.contains(eObj.eClass())) {
            if (eType == EMFEventType.NULL) {
                String id = null;
                if (eObj instanceof BaseElement) {
                    id = ((BaseElement)eObj).getId();
                }
                if (!SyntaxCheckerUtils.isNCName(id)) {
                    return ctx.createFailureStatus(new Object[]{eObj.eClass().getName()});
                }
            } else {
                String newValue = (String)ctx.getFeatureNewValue();
                if (!SyntaxCheckerUtils.isNCName(newValue)) {
                    return ctx.createFailureStatus(new Object[]{eObj.eClass().getName()});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

