/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;

public class GraphicsUtil {
    private static final IGaService gaService = Graphiti.getGaService();
    static final IPeService peService = Graphiti.getPeService();
    private static Map<Diagram, SizeTemplate> diagramSizeMap;
    public static final int DATA_WIDTH = 36;
    public static final int DATA_HEIGHT = 50;
    public static final int CHOREOGRAPHY_WIDTH = 150;
    public static final int CHOREOGRAPHY_HEIGHT = 150;
    public static final int PARTICIPANT_BAND_HEIGHT = 20;
    public static final int SHAPE_PADDING = 6;
    public static final int TEXT_PADDING = 5;
    public static final String LABEL_PROPERTY = "label";
    private static final String LINE_BREAK = "\n";
    private static final String DELETABLE_PROPERTY = "deletable";
    public static final int GATEWAY_RADIUS = 25;
    public static final int GATEWAY_TEXT_AREA = 15;
    public static final int EVENT_SIZE = 36;
    public static final int TASK_DEFAULT_WIDTH = 110;
    public static final int TASK_DEFAULT_HEIGHT = 50;
    public static final int TASK_IMAGE_SIZE = 16;
    public static final int SUB_PROCEESS_DEFAULT_WIDTH = 300;
    public static final int SUB_PROCESS_DEFAULT_HEIGHT = 300;
    public static final int MARKER_WIDTH = 10;
    public static final int MARKER_HEIGHT = 10;
    private static final String ACTIVITY_MARKER_CONTAINER = "activity.marker.container";
    public static final String ACTIVITY_MARKER_COMPENSATE = "activity.marker.compensate";
    public static final String ACTIVITY_MARKER_LC_STANDARD = "activity.marker.lc.standard";
    public static final String ACTIVITY_MARKER_LC_MULTI_SEQUENTIAL = "activity.marker.lc.multi.sequential";
    public static final String ACTIVITY_MARKER_LC_MULTI_PARALLEL = "activity.marker.lc.multi.parallel";
    public static final String ACTIVITY_MARKER_AD_HOC = "activity.marker.adhoc";
    public static final String ACTIVITY_MARKER_EXPAND = "activity.marker.expand";
    public static final String ACTIVITY_MARKER_OFFSET = "activity.marker.offset";
    public static final String EVENT_MARKER_CONTAINER = "event.marker.container";
    public static boolean debug;

    static {
        debug = false;
    }

    private static int generateRatioPointValue(float originalPointValue, float ratioValue) {
        return Math.round(Float.valueOf(originalPointValue * ratioValue).floatValue());
    }

    public static int getLabelHeight(AbstractText text) {
        if (text.getValue() != null && !text.getValue().isEmpty()) {
            int height = 14;
            String[] strings = text.getValue().split(LINE_BREAK);
            if (strings.length > 0) {
                IDimension dim = GraphitiUi.getUiLayoutService().calculateTextSize(strings[0], text.getFont());
                height = dim.getHeight();
            }
            return strings.length * height;
        }
        return 0;
    }

    public static int getLabelWidth(AbstractText text) {
        if (text.getValue() != null && !text.getValue().isEmpty()) {
            String[] strings = text.getValue().split(LINE_BREAK);
            int result = 0;
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                IDimension dim = GraphitiUi.getUiLayoutService().calculateTextSize(string, text.getFont());
                if (dim.getWidth() > result) {
                    result = dim.getWidth();
                }
                ++n2;
            }
            return result;
        }
        return 0;
    }

    public static void alignWithShape(AbstractText text, ContainerShape labelContainer, int width, int height, int shapeX, int shapeY, int preShapeX, int preShapeY) {
        int textHeight = GraphicsUtil.getLabelHeight(text);
        int textWidth = GraphicsUtil.getLabelWidth(text);
        int currentLabelX = labelContainer.getGraphicsAlgorithm().getX();
        int currentLabelY = labelContainer.getGraphicsAlgorithm().getY();
        int newShapeX = shapeX - (textWidth + 6) / 2 + width / 2;
        int newShapeY = shapeY + height + 2;
        if (currentLabelX > 0 && preShapeX > 0) {
            newShapeX = currentLabelX + (shapeX - preShapeX);
            newShapeY = currentLabelY + (shapeY - preShapeY);
        }
        IGaService gaService = Graphiti.getGaService();
        gaService.setLocationAndSize(labelContainer.getGraphicsAlgorithm(), newShapeX, newShapeY, textWidth + 6, textHeight + 6);
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, textWidth + 5, textHeight + 5);
    }

    private static float calculateRatio(float x, float y) {
        return x / y;
    }

    private static int getShapeHeight(Shape shape) {
        return shape.getGraphicsAlgorithm().getHeight();
    }

    private static int getShapeWidth(Shape shape) {
        return shape.getGraphicsAlgorithm().getWidth();
    }

    public static Shape getContainedShape(ContainerShape container, String propertyKey) {
        IPeService peService = Graphiti.getPeService();
        for (Shape shape : peService.getAllContainedShapes(container)) {
            String property = peService.getPropertyValue((PropertyContainer)shape, propertyKey);
            if (property == null || !new Boolean(property).booleanValue()) continue;
            return shape;
        }
        return null;
    }

    public static List<PictogramElement> getContainedPictogramElements(PictogramElement container, String propertyKey) {
        ArrayList<PictogramElement> pictogramElements = new ArrayList<PictogramElement>();
        IPeService peService = Graphiti.getPeService();
        for (PictogramElement pe : peService.getAllContainedPictogramElements(container)) {
            String property = peService.getPropertyValue((PropertyContainer)pe, propertyKey);
            if (property == null || !new Boolean(property).booleanValue()) continue;
            pictogramElements.add(pe);
        }
        return pictogramElements;
    }

    public static Polygon createGateway(Shape container, int width, int height) {
        int widthRadius = width / 2;
        int heightRadius = height / 2;
        int[] nArray = new int[8];
        nArray[1] = heightRadius;
        nArray[2] = widthRadius;
        nArray[4] = 2 * widthRadius;
        nArray[5] = heightRadius;
        nArray[6] = widthRadius;
        nArray[7] = 2 * heightRadius;
        int[] gateWayPoints = nArray;
        return gaService.createPolygon((GraphicsAlgorithmContainer)container, gateWayPoints);
    }

    public static Polygon createGatewayPentagon(ContainerShape container) {
        Shape pentagonShape = peService.createShape(container, false);
        int gatewayHeight = GraphicsUtil.getShapeHeight((Shape)container);
        int gatewayWidth = GraphicsUtil.getShapeWidth((Shape)container);
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Polygon pentagon = gaService.createPolygon((GraphicsAlgorithmContainer)pentagonShape, new int[]{gatewayWidth / 2, GraphicsUtil.generateRatioPointValue(18.0f, heightRatio), gatewayWidth / 2 + GraphicsUtil.generateRatioPointValue(8.0f, widthRatio), gatewayHeight / 2 - GraphicsUtil.generateRatioPointValue(2.0f, heightRatio), gatewayWidth / 2 + GraphicsUtil.generateRatioPointValue(5.0f, widthRatio), gatewayHeight / 2 + GraphicsUtil.generateRatioPointValue(7.0f, heightRatio), gatewayWidth / 2 - GraphicsUtil.generateRatioPointValue(5.0f, widthRatio), gatewayHeight / 2 + GraphicsUtil.generateRatioPointValue(7.0f, heightRatio), gatewayWidth / 2 - GraphicsUtil.generateRatioPointValue(8.0f, widthRatio), gatewayHeight / 2 - GraphicsUtil.generateRatioPointValue(2.0f, heightRatio)});
        peService.setPropertyValue((PropertyContainer)pentagonShape, DELETABLE_PROPERTY, "true");
        return pentagon;
    }

    public static Ellipse createGatewayInnerCircle(Ellipse outer) {
        int gatewayHeight = outer.getHeight();
        int gatewayWidth = outer.getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Float x = Float.valueOf(5.0f * widthRatio * new Float(0.8).floatValue());
        Float y = Float.valueOf(5.0f * heightRatio * new Float(0.8).floatValue());
        Float width = Float.valueOf((float)gatewayHeight * new Float(0.8).floatValue());
        Float height = Float.valueOf((float)gatewayWidth * new Float(0.8).floatValue());
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)outer);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, Math.round(x.floatValue()), Math.round(y.floatValue()), Math.round(width.floatValue()), Math.round(height.floatValue()));
        ellipse.setFilled(Boolean.valueOf(false));
        ellipse.setLineWidth(Integer.valueOf(1));
        peService.setPropertyValue((PropertyContainer)ellipse, DELETABLE_PROPERTY, "true");
        return ellipse;
    }

    public static Ellipse createGatewayOuterCircle(ContainerShape container) {
        Shape ellipseShape = peService.createShape(container, false);
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)ellipseShape);
        int gatewayHeight = GraphicsUtil.getShapeHeight((Shape)container);
        int gatewayWidth = GraphicsUtil.getShapeWidth((Shape)container);
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, GraphicsUtil.generateRatioPointValue(12.0f, widthRatio), GraphicsUtil.generateRatioPointValue(12.0f, heightRatio), GraphicsUtil.generateRatioPointValue(27.0f, widthRatio), GraphicsUtil.generateRatioPointValue(27.0f, heightRatio));
        ellipse.setFilled(Boolean.valueOf(false));
        ellipse.setLineWidth(Integer.valueOf(1));
        peService.setPropertyValue((PropertyContainer)ellipseShape, DELETABLE_PROPERTY, "true");
        return ellipse;
    }

    public static Cross createGatewayCross(ContainerShape container) {
        Shape verticalShape = peService.createShape(container, false);
        int gatewayHeight = GraphicsUtil.getShapeHeight((Shape)container);
        int gatewayWidth = GraphicsUtil.getShapeWidth((Shape)container);
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Polyline verticalLine = gaService.createPolyline((GraphicsAlgorithmContainer)verticalShape, new int[]{GraphicsUtil.generateRatioPointValue(24.0f, widthRatio), GraphicsUtil.generateRatioPointValue(7.0f, heightRatio), GraphicsUtil.generateRatioPointValue(24.0f, widthRatio), GraphicsUtil.generateRatioPointValue(43.0f, heightRatio)});
        verticalLine.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)verticalShape, DELETABLE_PROPERTY, "false");
        Shape horizontalShape = peService.createShape(container, false);
        Polyline horizontalLine = gaService.createPolyline((GraphicsAlgorithmContainer)horizontalShape, new int[]{GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), GraphicsUtil.generateRatioPointValue(24.0f, heightRatio), GraphicsUtil.generateRatioPointValue(43.0f, widthRatio), GraphicsUtil.generateRatioPointValue(24.0f, heightRatio)});
        horizontalLine.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)horizontalShape, DELETABLE_PROPERTY, "false");
        Cross cross = new Cross();
        cross.vertical = verticalLine;
        cross.horizontal = horizontalLine;
        return cross;
    }

    public static DiagonalCross createGatewayDiagonalCross(ContainerShape container) {
        IPeService service = Graphiti.getPeService();
        int gatewayHeight = GraphicsUtil.getShapeHeight((Shape)container);
        int gatewayWidth = GraphicsUtil.getShapeWidth((Shape)container);
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Shape diagonalDescShape = service.createShape(container, false);
        Polyline diagonalDesc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalDescShape, new int[]{GraphicsUtil.generateRatioPointValue(14.0f, widthRatio), GraphicsUtil.generateRatioPointValue(14.0f, heightRatio), GraphicsUtil.generateRatioPointValue(37.0f, widthRatio), GraphicsUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalDesc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalDescShape, DELETABLE_PROPERTY, "true");
        Shape diagonalAscShape = service.createShape(container, false);
        Polyline diagonalAsc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalAscShape, new int[]{GraphicsUtil.generateRatioPointValue(37.0f, widthRatio), GraphicsUtil.generateRatioPointValue(14.0f, heightRatio), GraphicsUtil.generateRatioPointValue(14.0f, widthRatio), GraphicsUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalAsc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalAscShape, DELETABLE_PROPERTY, "true");
        DiagonalCross diagonalCross = new DiagonalCross();
        diagonalCross.diagonalDesc = diagonalDesc;
        diagonalCross.diagonalAsc = diagonalAsc;
        return diagonalCross;
    }

    public static Polygon createEventGatewayParallelCross(ContainerShape container) {
        Shape crossShape = peService.createShape(container, false);
        int gatewayHeight = GraphicsUtil.getShapeHeight((Shape)container);
        int gatewayWidth = GraphicsUtil.getShapeWidth((Shape)container);
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        int n1x = GraphicsUtil.generateRatioPointValue(14.0f, widthRatio);
        int n1y = GraphicsUtil.generateRatioPointValue(14.0f, heightRatio);
        int n2x = GraphicsUtil.generateRatioPointValue(22.0f, widthRatio);
        int n2y = GraphicsUtil.generateRatioPointValue(22.0f, heightRatio);
        int n3x = GraphicsUtil.generateRatioPointValue(28.0f, widthRatio);
        int n3y = GraphicsUtil.generateRatioPointValue(28.0f, heightRatio);
        int n4x = GraphicsUtil.generateRatioPointValue(36.0f, widthRatio);
        int n4y = GraphicsUtil.generateRatioPointValue(36.0f, heightRatio);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(gaService.createPoint(n1x, n2y));
        points.add(gaService.createPoint(n2x, n2y));
        points.add(gaService.createPoint(n2x, n1y));
        points.add(gaService.createPoint(n3x, n1y));
        points.add(gaService.createPoint(n3x, n2y));
        points.add(gaService.createPoint(n4x, n2y));
        points.add(gaService.createPoint(n4x, n3y));
        points.add(gaService.createPoint(n3x, n3y));
        points.add(gaService.createPoint(n3x, n4y));
        points.add(gaService.createPoint(n2x, n4y));
        points.add(gaService.createPoint(n2x, n3y));
        points.add(gaService.createPoint(n1x, n3y));
        Polygon cross = gaService.createPolygon((GraphicsAlgorithmContainer)crossShape, points);
        cross.setFilled(Boolean.valueOf(false));
        cross.setLineWidth(Integer.valueOf(1));
        peService.setPropertyValue((PropertyContainer)crossShape, DELETABLE_PROPERTY, "true");
        return cross;
    }

    public static Asterisk createGatewayAsterisk(ContainerShape container) {
        IPeService service = Graphiti.getPeService();
        int gatewayHeight = GraphicsUtil.getShapeHeight((Shape)container);
        int gatewayWidth = GraphicsUtil.getShapeWidth((Shape)container);
        float heightRatio = GraphicsUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Shape verticalShape = service.createShape(container, false);
        Polyline vertical = gaService.createPolyline((GraphicsAlgorithmContainer)verticalShape, new int[]{GraphicsUtil.generateRatioPointValue(24.0f, widthRatio), GraphicsUtil.generateRatioPointValue(7.0f, heightRatio), GraphicsUtil.generateRatioPointValue(24.0f, widthRatio), GraphicsUtil.generateRatioPointValue(43.0f, heightRatio)});
        vertical.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)verticalShape, DELETABLE_PROPERTY, "true");
        Shape horizontalShape = service.createShape(container, false);
        Polyline horizontal = gaService.createPolyline((GraphicsAlgorithmContainer)horizontalShape, new int[]{GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), GraphicsUtil.generateRatioPointValue(24.0f, heightRatio), GraphicsUtil.generateRatioPointValue(43.0f, widthRatio), GraphicsUtil.generateRatioPointValue(24.0f, heightRatio)});
        horizontal.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)horizontalShape, DELETABLE_PROPERTY, "true");
        Shape diagonalDescShape = service.createShape(container, false);
        Polyline diagonalDesc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalDescShape, new int[]{GraphicsUtil.generateRatioPointValue(14.0f, widthRatio), GraphicsUtil.generateRatioPointValue(14.0f, heightRatio), GraphicsUtil.generateRatioPointValue(37.0f, widthRatio), GraphicsUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalDesc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalDescShape, DELETABLE_PROPERTY, "true");
        Shape diagonalAscShape = service.createShape(container, false);
        Polyline diagonalAsc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalAscShape, new int[]{GraphicsUtil.generateRatioPointValue(37.0f, widthRatio), GraphicsUtil.generateRatioPointValue(14.0f, heightRatio), GraphicsUtil.generateRatioPointValue(14.0f, widthRatio), GraphicsUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalAsc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalAscShape, DELETABLE_PROPERTY, "true");
        Asterisk a = new Asterisk();
        a.horizontal = horizontal;
        a.vertical = vertical;
        a.diagonalDesc = diagonalDesc;
        a.diagonalAsc = diagonalAsc;
        return a;
    }

    public static void clearGateway(PictogramElement element) {
        for (PictogramElement pe : GraphicsUtil.getContainedPictogramElements(element, DELETABLE_PROPERTY)) {
            peService.deletePictogramElement(pe);
        }
    }

    public static Ellipse createEventShape(Shape container, int width, int height) {
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)container);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, 0, 0, width, height);
        return ellipse;
    }

    public static Envelope createEventEnvelope(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        return GraphicsUtil.createEnvelope((GraphicsAlgorithmContainer)shape, GraphicsUtil.generateRatioPointValue(9.0f, widthRatio), GraphicsUtil.generateRatioPointValue(12.0f, heightRatio), GraphicsUtil.generateRatioPointValue(18.0f, widthRatio), GraphicsUtil.generateRatioPointValue(14.0f, heightRatio));
    }

    public static Polygon createEventPentagon(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        return gaService.createPolygon((GraphicsAlgorithmContainer)shape, new int[]{eventWidth / 2, GraphicsUtil.generateRatioPointValue(7.0f, heightRatio), eventWidth / 2 + GraphicsUtil.generateRatioPointValue(10.0f, widthRatio), eventHeight / 2 - GraphicsUtil.generateRatioPointValue(4.0f, heightRatio), eventWidth / 2 + GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), eventHeight / 2 + GraphicsUtil.generateRatioPointValue(10.0f, heightRatio), eventWidth / 2 - GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), eventHeight / 2 + GraphicsUtil.generateRatioPointValue(10.0f, heightRatio), eventWidth / 2 - GraphicsUtil.generateRatioPointValue(10.0f, widthRatio), eventHeight / 2 - GraphicsUtil.generateRatioPointValue(4.0f, heightRatio)});
    }

    public static Ellipse createIntermediateEventCircle(Ellipse ellipse) {
        int eventHeight = ellipse.getHeight();
        int eventWidth = ellipse.getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Float x = Float.valueOf(5.0f * widthRatio * new Float(0.8).floatValue());
        Float y = Float.valueOf(5.0f * heightRatio * new Float(0.8).floatValue());
        Float width = Float.valueOf((float)eventWidth * new Float(0.8).floatValue());
        Float height = Float.valueOf((float)eventHeight * new Float(0.8).floatValue());
        Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)ellipse);
        gaService.setLocationAndSize((GraphicsAlgorithm)circle, Math.round(x.floatValue()), Math.round(y.floatValue()), width.intValue(), height.intValue());
        circle.setLineWidth(Integer.valueOf(1));
        circle.setFilled(Boolean.valueOf(false));
        return circle;
    }

    public static Image createEventImage(Shape shape, String imageId) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Image image = gaService.createImage((GraphicsAlgorithmContainer)shape, imageId);
        gaService.setLocationAndSize((GraphicsAlgorithm)image, GraphicsUtil.generateRatioPointValue(8.0f, widthRatio), GraphicsUtil.generateRatioPointValue(8.0f, heightRatio), GraphicsUtil.generateRatioPointValue(20.0f, widthRatio), GraphicsUtil.generateRatioPointValue(20.0f, heightRatio));
        return image;
    }

    public static Polygon createEventSignal(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, new int[]{GraphicsUtil.generateRatioPointValue(16.0f, widthRatio), GraphicsUtil.generateRatioPointValue(4.0f, heightRatio), GraphicsUtil.generateRatioPointValue(28.0f, widthRatio), GraphicsUtil.generateRatioPointValue(26.0f, heightRatio), GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), GraphicsUtil.generateRatioPointValue(26.0f, heightRatio)});
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Polygon createEventEscalation(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int widthRadius = eventWidth / 2;
        int[] points = new int[]{widthRadius, GraphicsUtil.generateRatioPointValue(8.0f, heightRatio), widthRadius + GraphicsUtil.generateRatioPointValue(8.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(9.0f, heightRatio), widthRadius, heightRadius + GraphicsUtil.generateRatioPointValue(2.0f, heightRatio), widthRadius - GraphicsUtil.generateRatioPointValue(8.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(9.0f, heightRatio)};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Compensation createEventCompensation(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Rectangle rect = gaService.createInvisibleRectangle((PictogramElement)shape);
        int w = GraphicsUtil.generateRatioPointValue(22.0f, widthRatio);
        int h = GraphicsUtil.generateRatioPointValue(18.0f, heightRatio);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, GraphicsUtil.generateRatioPointValue(5.0f, widthRatio), GraphicsUtil.generateRatioPointValue(9.0f, heightRatio), w, h);
        int _w = w / 2;
        int _h = h / 2;
        int[] nArray = new int[6];
        nArray[0] = _w;
        nArray[2] = _w;
        nArray[3] = h;
        nArray[5] = _h;
        int[] pontsArrow1 = nArray;
        Polygon arrow1 = gaService.createPolygon((GraphicsAlgorithmContainer)rect, pontsArrow1);
        int[] nArray2 = new int[6];
        nArray2[0] = w;
        nArray2[2] = w;
        nArray2[3] = h;
        nArray2[4] = w / 2;
        nArray2[5] = _h;
        int[] pontsArrow2 = nArray2;
        Polygon arrow2 = gaService.createPolygon((GraphicsAlgorithmContainer)rect, pontsArrow2);
        Compensation compensation = new Compensation();
        compensation.arrow1 = arrow1;
        compensation.arrow2 = arrow2;
        return compensation;
    }

    public static Polygon createEventLink(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int[] points = new int[]{GraphicsUtil.generateRatioPointValue(32.0f, widthRatio), heightRadius, GraphicsUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(11.0f, heightRatio), GraphicsUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(6.0f, heightRatio), GraphicsUtil.generateRatioPointValue(5.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(6.0f, heightRatio), GraphicsUtil.generateRatioPointValue(5.0f, widthRatio), heightRadius - GraphicsUtil.generateRatioPointValue(6.0f, heightRatio), GraphicsUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius - GraphicsUtil.generateRatioPointValue(6.0f, heightRatio), GraphicsUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius - GraphicsUtil.generateRatioPointValue(11.0f, heightRatio)};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Polygon createEventError(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int widthRadius = eventWidth / 2;
        int[] points = new int[]{widthRadius + GraphicsUtil.generateRatioPointValue(4.0f, widthRatio), heightRadius, widthRadius + GraphicsUtil.generateRatioPointValue(10.0f, widthRatio), heightRadius - GraphicsUtil.generateRatioPointValue(10.0f, heightRatio), widthRadius + GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(10.0f, heightRatio), widthRadius - GraphicsUtil.generateRatioPointValue(4.0f, widthRatio), heightRadius, widthRadius - GraphicsUtil.generateRatioPointValue(10.0f, widthRatio), heightRadius + GraphicsUtil.generateRatioPointValue(10.0f, heightRatio), widthRadius - GraphicsUtil.generateRatioPointValue(7.0f, widthRatio), heightRadius - GraphicsUtil.generateRatioPointValue(10.0f, heightRatio)};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Polygon createEventCancel(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int widthRadius = eventWidth / 2;
        int a1 = GraphicsUtil.generateRatioPointValue(9.0f, widthRatio);
        int a2 = GraphicsUtil.generateRatioPointValue(9.0f, heightRatio);
        int b1 = GraphicsUtil.generateRatioPointValue(12.0f, widthRatio);
        int b2 = GraphicsUtil.generateRatioPointValue(12.0f, heightRatio);
        int c1 = GraphicsUtil.generateRatioPointValue(4.0f, widthRatio);
        int c2 = GraphicsUtil.generateRatioPointValue(4.0f, heightRatio);
        int[] points = new int[]{widthRadius, heightRadius - c2, widthRadius + a1, heightRadius - b2, widthRadius + b1, heightRadius - a2, widthRadius + c1, heightRadius, widthRadius + b1, heightRadius + a2, widthRadius + a1, heightRadius + b2, widthRadius, heightRadius + c2, widthRadius - a1, heightRadius + b2, widthRadius - b1, heightRadius + a2, widthRadius - c1, heightRadius, widthRadius - b1, heightRadius - a2, widthRadius - a1, heightRadius - b2};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Ellipse createEventTerminate(Shape terminateShape) {
        int eventHeight = terminateShape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = terminateShape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)terminateShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, GraphicsUtil.generateRatioPointValue(6.0f, widthRatio), GraphicsUtil.generateRatioPointValue(6.0f, heightRatio), eventWidth - GraphicsUtil.generateRatioPointValue(12.0f, widthRatio), eventHeight - GraphicsUtil.generateRatioPointValue(12.0f, heightRatio));
        ellipse.setLineWidth(Integer.valueOf(1));
        ellipse.setFilled(Boolean.valueOf(true));
        return ellipse;
    }

    public static Ellipse createEventNotAllowed(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = GraphicsUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = GraphicsUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)shape);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, GraphicsUtil.generateRatioPointValue(6.0f, widthRatio), GraphicsUtil.generateRatioPointValue(6.0f, heightRatio), eventWidth - GraphicsUtil.generateRatioPointValue(12.0f, widthRatio), eventHeight - GraphicsUtil.generateRatioPointValue(12.0f, heightRatio));
        ellipse.setLineWidth(Integer.valueOf(2));
        ellipse.setFilled(Boolean.valueOf(false));
        ellipse.setForeground(GraphicsUtil.manageColor((PictogramElement)shape, IColorConstant.RED));
        int[] points = new int[]{GraphicsUtil.generateRatioPointValue(8.0f, widthRatio), GraphicsUtil.generateRatioPointValue(12.0f, heightRatio), GraphicsUtil.generateRatioPointValue(28.0f, widthRatio), GraphicsUtil.generateRatioPointValue(24.0f, heightRatio)};
        shape = Graphiti.getPeService().createShape(shape.getContainer(), false);
        Polyline polygon = gaService.createPolyline((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(2));
        polygon.setForeground(GraphicsUtil.manageColor((PictogramElement)shape, IColorConstant.RED));
        return ellipse;
    }

    public static Polygon createEventParallelMultiple(Shape shape) {
        int r = 18;
        int a = 3;
        int b = 11;
        int[] points = new int[]{r - a, r - b, r + a, r - b, r + a, r - a, r + b, r - a, r + b, r + a, r + a, r + a, r + a, r + b, r - a, r + b, r - a, r + a, r - b, r + a, r - b, r - a, r - a, r - a};
        Polygon cross = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        cross.setFilled(Boolean.valueOf(false));
        cross.setLineWidth(Integer.valueOf(1));
        return cross;
    }

    public static void deleteEventShape(ContainerShape containerShape) {
        for (PictogramElement shape : containerShape.getChildren()) {
            EList objects;
            if (shape.getLink() == null || (objects = shape.getLink().getBusinessObjects()).size() <= 0 || !(objects.get(0) instanceof EventDefinition)) continue;
            peService.deletePictogramElement(shape);
            break;
        }
    }

    public static Envelope createEnvelope(GraphicsAlgorithmContainer gaContainer, int x, int y, int w, int h) {
        Rectangle rect = gaService.createRectangle(gaContainer);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, x, y, w, h);
        rect.setFilled(Boolean.valueOf(false));
        int[] nArray = new int[6];
        nArray[2] = w / 2;
        nArray[3] = h / 2;
        nArray[4] = w;
        Polyline line = gaService.createPolyline((GraphicsAlgorithmContainer)rect, nArray);
        Envelope envelope = new Envelope();
        envelope.rect = rect;
        envelope.line = line;
        return envelope;
    }

    public static Polygon createDataArrow(Polygon p) {
        int[] points = new int[]{4, 8, 14, 8, 14, 4, 18, 10, 14, 16, 14, 12, 4, 12};
        Polygon arrow = gaService.createPolygon((GraphicsAlgorithmContainer)p, points);
        arrow.setLineWidth(Integer.valueOf(1));
        return arrow;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerCompensate(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = GraphicsUtil.createActivityMarkerGaContainer(markerContainer, ACTIVITY_MARKER_COMPENSATE);
        Compensation compensation = GraphicsUtil.createCompensation(algorithmContainer, 10, 10);
        compensation.arrow1.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        compensation.arrow2.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerStandardLoop(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = GraphicsUtil.createActivityMarkerGaContainer(markerContainer, ACTIVITY_MARKER_LC_STANDARD);
        int[] nArray = new int[10];
        nArray[0] = 8;
        nArray[1] = 10;
        nArray[2] = 10;
        nArray[3] = 5;
        nArray[4] = 5;
        nArray[7] = 5;
        nArray[8] = 3;
        nArray[9] = 10;
        int[] xy = nArray;
        int[] nArray2 = new int[10];
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 4;
        nArray2[5] = 4;
        nArray2[6] = 4;
        nArray2[7] = 3;
        nArray2[8] = 3;
        int[] bend = nArray2;
        Polyline circle = gaService.createPolyline(algorithmContainer, xy, bend);
        Loop loop = new Loop();
        loop.circle = circle;
        int[] nArray3 = new int[6];
        nArray3[0] = 5;
        nArray3[1] = 5;
        nArray3[2] = 5;
        nArray3[3] = 10;
        nArray3[5] = 10;
        loop.arrow = gaService.createPolyline(algorithmContainer, nArray3);
        loop.circle.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        loop.arrow.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerMultiParallel(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = GraphicsUtil.createActivityMarkerGaContainer(markerContainer, ACTIVITY_MARKER_LC_MULTI_PARALLEL);
        MultiInstance multiInstance = new MultiInstance();
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = 2;
        nArray[3] = 10;
        multiInstance.line1 = gaService.createPolyline(algorithmContainer, nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 5;
        nArray2[2] = 5;
        nArray2[3] = 10;
        multiInstance.line2 = gaService.createPolyline(algorithmContainer, nArray2);
        int[] nArray3 = new int[4];
        nArray3[0] = 8;
        nArray3[2] = 8;
        nArray3[3] = 10;
        multiInstance.line3 = gaService.createPolyline(algorithmContainer, nArray3);
        multiInstance.line1.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line2.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line3.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerMultiSequential(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = GraphicsUtil.createActivityMarkerGaContainer(markerContainer, ACTIVITY_MARKER_LC_MULTI_SEQUENTIAL);
        MultiInstance multiInstance = new MultiInstance();
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 10;
        nArray[3] = 2;
        multiInstance.line1 = gaService.createPolyline(algorithmContainer, nArray);
        int[] nArray2 = new int[4];
        nArray2[1] = 5;
        nArray2[2] = 10;
        nArray2[3] = 5;
        multiInstance.line2 = gaService.createPolyline(algorithmContainer, nArray2);
        int[] nArray3 = new int[4];
        nArray3[1] = 8;
        nArray3[2] = 10;
        nArray3[3] = 8;
        multiInstance.line3 = gaService.createPolyline(algorithmContainer, nArray3);
        multiInstance.line1.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line2.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line3.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerAdHoc(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = GraphicsUtil.createActivityMarkerGaContainer(markerContainer, ACTIVITY_MARKER_AD_HOC);
        int[] nArray = new int[8];
        nArray[1] = 8;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 7;
        nArray[5] = 8;
        nArray[6] = 10;
        nArray[7] = 2;
        int[] xy = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 3;
        int[] bend = nArray2;
        Polyline tilde = gaService.createPolyline(algorithmContainer, xy, bend);
        tilde.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerExpand(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = GraphicsUtil.createActivityMarkerGaContainer(markerContainer, ACTIVITY_MARKER_EXPAND);
        Rectangle rect = gaService.createRectangle(algorithmContainer);
        rect.setFilled(Boolean.valueOf(false));
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, 0, 0, 10, 10);
        Expand expand = new Expand();
        expand.rect = rect;
        int[] nArray = new int[4];
        nArray[1] = 5;
        nArray[2] = 10;
        nArray[3] = 5;
        expand.horizontal = gaService.createPolyline(algorithmContainer, nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 5;
        nArray2[2] = 5;
        nArray2[3] = 10;
        expand.vertical = gaService.createPolyline(algorithmContainer, nArray2);
        expand.rect.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        expand.horizontal.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        expand.vertical.setForeground(GraphicsUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static ContainerShape getActivityMarkerContainer(ContainerShape container) {
        String property = peService.getPropertyValue((PropertyContainer)container, ACTIVITY_MARKER_CONTAINER);
        if (property != null && new Boolean(property).booleanValue()) {
            return container;
        }
        return (ContainerShape)GraphicsUtil.getContainedShape(container, ACTIVITY_MARKER_CONTAINER);
    }

    private static ContainerShape createActivityMarkerContainer(ContainerShape container) {
        ContainerShape markerContainer = GraphicsUtil.getActivityMarkerContainer(container);
        if (markerContainer == null) {
            markerContainer = peService.createContainerShape(container, false);
            Rectangle markerInvisibleRect = gaService.createInvisibleRectangle((PictogramElement)markerContainer);
            GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
            int x = ga.getWidth() / 2;
            int y = ga.getHeight() - 10;
            int w = 50;
            int h = 10;
            gaService.setLocationAndSize((GraphicsAlgorithm)markerInvisibleRect, x, y, w, h);
            peService.setPropertyValue((PropertyContainer)markerContainer, ACTIVITY_MARKER_CONTAINER, Boolean.toString(true));
            GraphicsUtil.createActivityMarkerCompensate(markerContainer);
            GraphicsUtil.createActivityMarkerStandardLoop(markerContainer);
            GraphicsUtil.createActivityMarkerMultiParallel(markerContainer);
            GraphicsUtil.createActivityMarkerMultiSequential(markerContainer);
            GraphicsUtil.createActivityMarkerAdHoc(markerContainer);
            GraphicsUtil.createActivityMarkerExpand(markerContainer);
            for (Shape shape : peService.getAllContainedShapes(markerContainer)) {
                shape.setVisible(false);
            }
        }
        return markerContainer;
    }

    public static void setActivityMarkerOffest(ContainerShape container, int offset) {
        peService.setPropertyValue((PropertyContainer)container, ACTIVITY_MARKER_OFFSET, Integer.toString(offset));
    }

    public static int getActivityMarkerOffest(ContainerShape container) {
        int offset = 0;
        String s = peService.getPropertyValue((PropertyContainer)container, ACTIVITY_MARKER_OFFSET);
        if (s != null) {
            try {
                offset = Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        return offset;
    }

    public static void layoutActivityMarkerContainer(ContainerShape container) {
        ContainerShape markerContainer = GraphicsUtil.getActivityMarkerContainer(container);
        if (markerContainer != null) {
            GraphicsAlgorithm ga;
            int lastX = 0;
            for (Shape marker : peService.getAllContainedShapes(markerContainer)) {
                if (!marker.isVisible()) continue;
                ga = marker.getGraphicsAlgorithm();
                gaService.setLocation(ga, lastX, 0);
                lastX += ga.getWidth() + 3;
            }
            GraphicsAlgorithm parentGa = container.getGraphicsAlgorithm();
            ga = markerContainer.getGraphicsAlgorithm();
            int newWidth = parentGa.getWidth();
            int newHeight = parentGa.getHeight();
            int x = newWidth / 2 - lastX / 2;
            int y = newHeight - 13 - GraphicsUtil.getActivityMarkerOffest(container);
            gaService.setLocation(ga, x, y);
        }
    }

    public static void showActivityMarker(ContainerShape container, String property) {
        ContainerShape markerContainer = GraphicsUtil.getActivityMarkerContainer(container);
        if (markerContainer == null) {
            markerContainer = GraphicsUtil.createActivityMarkerContainer(container);
        }
        GraphicsUtil.getContainedShape(markerContainer, property).setVisible(true);
        GraphicsUtil.layoutActivityMarkerContainer(container);
    }

    public static void hideActivityMarker(ContainerShape container, String property) {
        ContainerShape markerContainer = GraphicsUtil.getActivityMarkerContainer(container);
        if (markerContainer == null) {
            markerContainer = GraphicsUtil.createActivityMarkerContainer(container);
        }
        GraphicsUtil.getContainedShape(markerContainer, property).setVisible(false);
        GraphicsUtil.layoutActivityMarkerContainer(container);
    }

    private static Color manageColor(PictogramElement pe, IColorConstant colorConstant) {
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement(pe);
        return Graphiti.getGaService().manageColor(diagram, colorConstant);
    }

    private static GraphicsAlgorithmContainer createActivityMarkerGaContainer(ContainerShape markerContainer, String property) {
        GraphicsAlgorithm ga = markerContainer.getGraphicsAlgorithm();
        int totalWidth = 10;
        int parentW = ((ContainerShape)markerContainer.eContainer()).getGraphicsAlgorithm().getWidth();
        int parentH = ((ContainerShape)markerContainer.eContainer()).getGraphicsAlgorithm().getHeight();
        int lastX = 0;
        for (Shape containedShape : peService.getAllContainedShapes(markerContainer)) {
            if (!containedShape.isVisible()) continue;
            GraphicsAlgorithm containedGa = containedShape.getGraphicsAlgorithm();
            totalWidth += containedGa.getWidth();
            lastX = containedGa.getX() + containedGa.getWidth();
        }
        gaService.setLocationAndSize(ga, parentW / 2 - totalWidth / 2, parentH - 10, totalWidth, 10);
        Shape shape = peService.createShape(markerContainer, false);
        peService.setPropertyValue((PropertyContainer)shape, property, Boolean.toString(true));
        Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)shape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, lastX, 0, 10, 10);
        return invisibleRect;
    }

    private static Compensation createCompensation(GraphicsAlgorithmContainer container, int w, int h) {
        int[] nArray = new int[6];
        nArray[1] = h / 2;
        nArray[2] = w / 2;
        nArray[4] = w / 2;
        nArray[5] = h;
        int[] xy = nArray;
        Polygon arrow1 = gaService.createPolygon(container, xy);
        arrow1.setFilled(Boolean.valueOf(false));
        int[] nArray2 = new int[6];
        nArray2[0] = w / 2;
        nArray2[1] = h / 2;
        nArray2[2] = w;
        nArray2[4] = w;
        nArray2[5] = h;
        xy = nArray2;
        Polygon arrow2 = gaService.createPolygon(container, xy);
        arrow2.setFilled(Boolean.valueOf(false));
        Compensation compensation = new Compensation();
        compensation.arrow1 = arrow1;
        compensation.arrow2 = arrow2;
        return compensation;
    }

    public static boolean isPointNear(Point p, ILocation loc, int dist) {
        int x = p.getX();
        int y = p.getY();
        int lx = loc.getX();
        int ly = loc.getY();
        return lx - dist <= x && x <= lx + dist && ly - dist <= y && y <= ly + dist;
    }

    public static void setEventSize(int width, int height, Diagram diagram) {
        SizeTemplate sizeTemplate;
        if (diagramSizeMap == null) {
            diagramSizeMap = new HashMap<Diagram, SizeTemplate>();
            SizeTemplate temp = new SizeTemplate();
            temp.setEventSize(new Size(36, 36));
            temp.setGatewaySize(new Size(50, 50));
        }
        if ((sizeTemplate = diagramSizeMap.get(diagram)) == null) {
            sizeTemplate = new SizeTemplate();
            diagramSizeMap.put(diagram, sizeTemplate);
        }
        sizeTemplate.setEventSize(new Size(width, height));
    }

    public static void setGatewaySize(int width, int height, Diagram diagram) {
        SizeTemplate sizeTemplate;
        if (diagramSizeMap == null) {
            diagramSizeMap = new HashMap<Diagram, SizeTemplate>();
        }
        if ((sizeTemplate = diagramSizeMap.get(diagram)) == null) {
            sizeTemplate = new SizeTemplate();
            diagramSizeMap.put(diagram, sizeTemplate);
        }
        sizeTemplate.setGatewaySize(new Size(width, height));
    }

    public static void setActivitySize(int width, int height, Diagram diagram) {
        SizeTemplate sizeTemplate;
        if (diagramSizeMap == null) {
            diagramSizeMap = new HashMap<Diagram, SizeTemplate>();
        }
        if ((sizeTemplate = diagramSizeMap.get(diagram)) == null) {
            sizeTemplate = new SizeTemplate();
            diagramSizeMap.put(diagram, sizeTemplate);
        }
        sizeTemplate.setActivitySize(new Size(width, height));
    }

    public static Size getEventSize(Diagram diagram) {
        SizeTemplate temp;
        if (diagramSizeMap != null && (temp = diagramSizeMap.get(diagram)) != null) {
            return temp.getEventSize();
        }
        return new Size(36, 36);
    }

    public static Size getGatewaySize(Diagram diagram) {
        SizeTemplate temp;
        if (diagramSizeMap != null && (temp = diagramSizeMap.get(diagram)) != null) {
            return temp.getGatewaySize();
        }
        return new Size(50, 50);
    }

    public static Size getActivitySize(Diagram diagram) {
        SizeTemplate temp;
        if (diagramSizeMap != null && (temp = diagramSizeMap.get(diagram)) != null) {
            return temp.getActivitySize();
        }
        return new Size(110, 50);
    }

    public static Size getChoreographySize(Diagram diagram) {
        SizeTemplate temp;
        if (diagramSizeMap != null && (temp = diagramSizeMap.get(diagram)) != null) {
            return temp.getChoreographySize();
        }
        return new Size(150, 150);
    }

    public static Size getPoolSize(Diagram diagram) {
        SizeTemplate temp;
        if (diagramSizeMap != null && (temp = diagramSizeMap.get(diagram)) != null) {
            return temp.getPoolSize();
        }
        return new Size(600, 150);
    }

    public static Size getParticipantBandSize(Diagram diagram) {
        SizeTemplate temp;
        if (diagramSizeMap != null && (temp = diagramSizeMap.get(diagram)) != null) {
            return temp.getParticipantBandSize();
        }
        return new Size(150, 20);
    }

    public static Size getShapeSize(BaseElement be, Diagram diagram) {
        if (be instanceof Event) {
            return GraphicsUtil.getEventSize(diagram);
        }
        if (be instanceof Gateway) {
            return GraphicsUtil.getGatewaySize(diagram);
        }
        if (be instanceof Activity) {
            return GraphicsUtil.getActivitySize(diagram);
        }
        if (be instanceof ChoreographyActivity) {
            return GraphicsUtil.getChoreographySize(diagram);
        }
        if (be instanceof Participant) {
            if (ModelUtil.isParticipantBand((Participant)be)) {
                return GraphicsUtil.getParticipantBandSize(diagram);
            }
            return GraphicsUtil.getPoolSize(diagram);
        }
        return new Size(110, 50);
    }

    public static boolean contains(Shape parent, Shape child) {
        IDimension size = GraphicsUtil.calculateSize((AnchorContainer)child);
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(child);
        return GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX(), loc.getY())) && GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX() + size.getWidth(), loc.getY())) && GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX() + size.getWidth(), loc.getY() + size.getHeight())) && GraphicsUtil.contains(parent, GraphicsUtil.createPoint(loc.getX(), loc.getY() + size.getHeight()));
    }

    public static boolean contains(Shape shape, Point point) {
        IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(shape);
        int x = point.getX();
        int y = point.getY();
        return x > loc.getX() && x < loc.getX() + size.getWidth() && y > loc.getY() && y < loc.getY() + size.getHeight();
    }

    public static boolean intersects(Shape shape1, Shape shape2) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation loc2 = layoutService.getLocationRelativeToDiagram(shape2);
        int x2 = loc2.getX();
        int y2 = loc2.getY();
        int w2 = GraphicsUtil.getShapeWidth(shape2);
        int h2 = GraphicsUtil.getShapeHeight(shape2);
        return GraphicsUtil.intersects(shape1, x2, y2, w2, h2);
    }

    public static boolean intersects(Shape shape1, int x2, int y2, int w2, int h2) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation loc1 = layoutService.getLocationRelativeToDiagram(shape1);
        int x1 = loc1.getX();
        int y1 = loc1.getY();
        int w1 = GraphicsUtil.getShapeWidth(shape1);
        int h1 = GraphicsUtil.getShapeHeight(shape1);
        return GraphicsUtil.intersects(x1, y1, w1, h1, x2, y2, w2, h2);
    }

    public static boolean intersects(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        if (x2 <= x1 || y1 <= y2) {
            int t1 = x1;
            x1 = x2;
            x2 = t1;
            int t2 = y1;
            y1 = y2;
            y2 = t2;
            int t3 = w1;
            w1 = w2;
            w2 = t3;
            int t4 = h1;
            h1 = h2;
            h2 = t4;
        }
        return y2 + h2 >= y1 && y1 + h1 >= y2 && x2 + w2 >= x1 && x1 + w1 >= x2;
    }

    public static boolean intersects(Shape shape, Connection connection) {
        Point p1 = GraphicsUtil.createPoint(connection.getStart());
        Point p3 = GraphicsUtil.createPoint(connection.getEnd());
        if (connection instanceof FreeFormConnection) {
            FreeFormConnection ffc = (FreeFormConnection)connection;
            Point p2 = p1;
            for (Point p : ffc.getBendpoints()) {
                if (GraphicsUtil.intersectsLine(shape, p1, p)) {
                    return true;
                }
                p2 = p1 = p;
            }
            if (GraphicsUtil.intersectsLine(shape, p2, p3)) {
                return true;
            }
        } else if (GraphicsUtil.intersectsLine(shape, p1, p3)) {
            return true;
        }
        return false;
    }

    public static boolean intersectsLine(Shape shape, Point p1, Point p2) {
        ILocation loc = peService.getLocationRelativeToDiagram(shape);
        IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
        if (size.getWidth() > 2) {
            loc.setX(loc.getX() + 1);
            size.setWidth(size.getWidth() - 2);
        }
        if (size.getHeight() > 2) {
            loc.setY(loc.getY() + 1);
            size.setHeight(size.getHeight() - 2);
        }
        return RectangleIntersectsLine.intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    public static boolean intersects(Point p1Start, Point p1End, Point p2Start, Point p2End) {
        return GraphicsUtil.isLineIntersectingLine(p1Start.getX(), p1Start.getY(), p1End.getX(), p1End.getY(), p2Start.getX(), p2Start.getY(), p2End.getX(), p2End.getY());
    }

    public static boolean isLineIntersectingLine(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
        int s1 = GraphicsUtil.sameSide(x0, y0, x1, y1, x2, y2, x3, y3);
        int s2 = GraphicsUtil.sameSide(x2, y2, x3, y3, x0, y0, x1, y1);
        return s1 <= 0 && s2 <= 0;
    }

    private static int sameSide(int x0, int y0, int x1, int y1, int px0, int py0, int px1, int py1) {
        int sameSide = 0;
        int dx = x1 - x0;
        int dy = y1 - y0;
        int dx1 = px0 - x0;
        int dy1 = py0 - y0;
        int dx2 = px1 - x1;
        int dy2 = py1 - y1;
        int c1 = dx * dy1 - dy * dx1;
        int c2 = dx * dy2 - dy * dx2;
        if (c1 != 0 && c2 != 0) {
            sameSide = c1 < 0 != c2 < 0 ? -1 : 1;
        } else if (dx == 0 && dx1 == 0 && dx2 == 0) {
            sameSide = !GraphicsUtil.isBetween(y0, y1, py0) && !GraphicsUtil.isBetween(y0, y1, py1) ? 1 : 0;
        } else if (dy == 0 && dy1 == 0 && dy2 == 0) {
            sameSide = !GraphicsUtil.isBetween(x0, x1, px0) && !GraphicsUtil.isBetween(x0, x1, px1) ? 1 : 0;
        }
        return sameSide;
    }

    private static boolean isBetween(int a, int b, int c) {
        return b > a ? c >= a && c <= b : c >= b && c <= a;
    }

    public static Color clone(Color c) {
        return c;
    }

    public static boolean pointsEqual(Point p1, Point p2) {
        return p1.getX() == p2.getX() && p1.getY() == p2.getY();
    }

    public static Point createPoint(Point p) {
        return gaService.createPoint(p.getX(), p.getY());
    }

    public static Point createPoint(int x, int y) {
        return gaService.createPoint(x, y);
    }

    public static Point createPoint(Anchor a) {
        return GraphicsUtil.createPoint(peService.getLocationRelativeToDiagram(a));
    }

    public static Point createPoint(AnchorContainer ac) {
        if (ac instanceof Shape) {
            return GraphicsUtil.createPoint(peService.getLocationRelativeToDiagram((Shape)ac));
        }
        return null;
    }

    public static Point getShapeCenter(AnchorContainer shape) {
        Point p = GraphicsUtil.createPoint(shape);
        IDimension size = GraphicsUtil.calculateSize(shape);
        p.setX(p.getX() + size.getWidth() / 2);
        p.setY(p.getY() + size.getHeight() / 2);
        return p;
    }

    public static Point createPoint(ILocation loc) {
        return GraphicsUtil.createPoint(loc.getX(), loc.getY());
    }

    public static Point getMidpoint(Point p1, Point p2) {
        int dx = p2.getX() - p1.getX();
        int dy = p2.getY() - p1.getY();
        int x = p1.getX() + dx / 2;
        int y = p1.getY() + dy / 2;
        return GraphicsUtil.createPoint(x, y);
    }

    public static double getLength(ILocation start, ILocation end) {
        double a = start.getX() - end.getX();
        double b = start.getY() - end.getY();
        return Math.sqrt(a * a + b * b);
    }

    public static double getLength(List<Point> points) {
        double length = 0.0;
        int size = points.size();
        if (size >= 2) {
            Point p1 = points.get(0);
            int i = 1;
            while (i < size - 1) {
                Point p2 = points.get(i);
                length += GraphicsUtil.getLength(p1, p2);
                p1 = p2;
                ++i;
            }
        }
        return length;
    }

    public static double getLength(Point p1, Point p2) {
        double a = p1.getX() - p2.getX();
        double b = p1.getY() - p2.getY();
        return Math.sqrt(a * a + b * b);
    }

    public static final boolean isVertical(Point p1, Point p2) {
        return Math.abs(p1.getX() - p2.getX()) == 0;
    }

    public static final boolean isHorizontal(Point p1, Point p2) {
        return Math.abs(p1.getY() - p2.getY()) == 0;
    }

    public static final boolean isSlanted(Point p1, Point p2) {
        return !GraphicsUtil.isHorizontal(p1, p2) && !GraphicsUtil.isVertical(p1, p2);
    }

    public static Point getVertMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getY() - start.getY()));
        m.setY(start.getY() + d);
        return m;
    }

    public static Point getHorzMidpoint(Point start, Point end, double fract) {
        Point m = GraphicsUtil.createPoint(start);
        int d = (int)(fract * (double)(end.getX() - start.getX()));
        m.setX(start.getX() + d);
        return m;
    }

    public static IDimension calculateSize(AnchorContainer shape) {
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        if (ga != null) {
            return gaService.calculateSize(ga);
        }
        IDimension dim = null;
        if (shape instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)shape;
            for (Shape s : cs.getChildren()) {
                ga = s.getGraphicsAlgorithm();
                if (ga == null) continue;
                IDimension d = gaService.calculateSize(ga);
                if (dim == null) {
                    dim = d;
                    continue;
                }
                if (d.getWidth() > dim.getWidth()) {
                    dim.setWidth(d.getWidth());
                }
                if (d.getHeight() <= dim.getHeight()) continue;
                dim.setHeight(d.getHeight());
            }
        }
        return dim;
    }

    public static void dump(String label, List<ContainerShape> shapes) {
        if (shapes != null && debug) {
            System.out.println(label);
            for (ContainerShape shape : shapes) {
                GraphicsUtil.dump(1, "", shape, 0, 0);
            }
            System.out.println("");
        }
    }

    public static void dump(String label, Anchor anchor) {
        if (debug) {
            String property;
            System.out.print(String.valueOf(label) + " ");
            ILocation loc = peService.getLocationRelativeToDiagram(anchor);
            System.out.print(" at " + loc.getX() + ", " + loc.getY());
            GraphicsUtil.dump(" parent=", (ContainerShape)anchor.getParent());
            if (AnchorUtil.isBoundaryAnchor(anchor) && (property = Graphiti.getPeService().getPropertyValue((PropertyContainer)anchor, "boundary.fixpoint.anchor")) != null && anchor instanceof FixPointAnchor) {
                System.out.println(" location=" + (Object)((Object)AnchorUtil.AnchorLocation.getLocation(property)));
            }
        }
    }

    public static void dump(String label, ContainerShape shape) {
        GraphicsUtil.dump(0, label, shape, 0, 0);
    }

    public static void dump(int level, String label, ContainerShape shape) {
        GraphicsUtil.dump(level, label, shape, 0, 0);
    }

    public static void dump(int level, String label, ContainerShape shape, int x, int y) {
        if (debug) {
            String text = GraphicsUtil.getDebugText(shape);
            int i = 0;
            while (i < level) {
                System.out.print("    ");
                ++i;
            }
            System.out.print(String.valueOf(label) + " " + text);
            if (x > 0 && y > 0) {
                System.out.println(" at " + x + ", " + y);
            } else {
                System.out.println("");
            }
        }
    }

    public static String getDebugText(ContainerShape shape) {
        EObject be = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape);
        String id = "";
        if (be instanceof BaseElement) {
            id = " " + ((BaseElement)be).getId();
        }
        String text = String.valueOf(be.eClass().getName()) + id + ": " + ModelUtil.getDisplayName(be);
        return text;
    }

    public static void dump(String label) {
        if (debug) {
            System.out.println(label);
        }
    }

    public static LineSegment[] getEdges(Shape shape) {
        ILocation loc = peService.getLocationRelativeToDiagram(shape);
        IDimension size = GraphicsUtil.calculateSize((AnchorContainer)shape);
        LineSegment top = new LineSegment(loc.getX(), loc.getY(), loc.getX() + size.getWidth(), loc.getY());
        LineSegment left = new LineSegment(loc.getX(), loc.getY(), loc.getX(), loc.getY() + size.getHeight());
        LineSegment bottom = new LineSegment(loc.getX(), loc.getY() + size.getHeight(), loc.getX() + size.getWidth(), loc.getY() + size.getHeight());
        LineSegment right = new LineSegment(loc.getX() + size.getWidth(), loc.getY(), loc.getX() + size.getWidth(), loc.getY() + size.getHeight());
        return new LineSegment[]{top, bottom, left, right};
    }

    public static LineSegment findNearestEdge(Shape shape, Point p) {
        LineSegment[] edges = GraphicsUtil.getEdges(shape);
        LineSegment top = edges[0];
        LineSegment bottom = edges[1];
        LineSegment left = edges[2];
        LineSegment right = edges[3];
        double minDist = top.getDistance(p);
        LineSegment result = top;
        double dist = bottom.getDistance(p);
        if (dist < minDist) {
            minDist = dist;
            result = bottom;
        }
        if ((dist = left.getDistance(p)) < minDist) {
            minDist = dist;
            result = left;
        }
        if ((dist = right.getDistance(p)) < minDist) {
            minDist = dist;
            result = right;
        }
        return result;
    }

    public static void sendToFront(Shape shape) {
        peService.sendToFront(shape);
        BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BPMNShape.class);
        if (bpmnShape != null) {
            BPMNPlane plane = (BPMNPlane)bpmnShape.eContainer();
            plane.getPlaneElement().remove(bpmnShape);
            plane.getPlaneElement().add(bpmnShape);
        }
    }

    public static void sendToBack(Shape shape) {
        peService.sendToBack(shape);
        BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BPMNShape.class);
        if (bpmnShape != null) {
            BPMNPlane plane = (BPMNPlane)bpmnShape.eContainer();
            plane.getPlaneElement().remove(bpmnShape);
            plane.getPlaneElement().add(0, bpmnShape);
        }
    }

    public static Shape findShapeAt(ContainerShape containerShape, Point p, IShapeFilter filter) {
        for (Shape c : containerShape.getChildren()) {
            Shape cc;
            if (c instanceof ContainerShape && (cc = GraphicsUtil.findShapeAt((ContainerShape)c, p, filter)) != null) {
                return cc;
            }
            if (!GraphicsUtil.contains(c, p) || !filter.matches(c)) continue;
            return c;
        }
        return null;
    }

    public static class Asterisk {
        public Polyline horizontal;
        public Polyline vertical;
        public Polyline diagonalDesc;
        public Polyline diagonalAsc;
    }

    public static class Compensation {
        public Polygon arrow1;
        public Polygon arrow2;
    }

    public class ContainerShapeFilter
    implements IShapeFilter {
        @Override
        public boolean matches(Shape shape) {
            return shape instanceof ContainerShape && !FeatureSupport.isLabelShape(shape);
        }
    }

    public static class Cross {
        public Polyline vertical;
        public Polyline horizontal;
    }

    public static class DiagonalCross {
        public Polyline diagonalAsc;
        public Polyline diagonalDesc;
    }

    public static class Envelope {
        public Rectangle rect;
        public Polyline line;
    }

    public static class Expand {
        public Rectangle rect;
        public Polyline horizontal;
        public Polyline vertical;
    }

    public static interface IShapeFilter {
        public boolean matches(Shape var1);
    }

    public static class LineSegment {
        private Point start;
        private Point end;

        public LineSegment() {
            this(0, 0, 0, 0);
        }

        public LineSegment(Point start, Point end) {
            this(start.getX(), start.getY(), end.getX(), end.getY());
        }

        public LineSegment(int x1, int y1, int x2, int y2) {
            this.start = Graphiti.getCreateService().createPoint(x1, y1);
            this.end = Graphiti.getCreateService().createPoint(x2, y2);
        }

        public void setStart(Point p) {
            this.setStart(p.getX(), p.getY());
        }

        public void setStart(int x, int y) {
            this.start.setX(x);
            this.start.setY(y);
        }

        public void setEnd(Point p) {
            this.setEnd(p.getX(), p.getY());
        }

        public void setEnd(int x, int y) {
            this.end.setX(x);
            this.end.setY(y);
        }

        public Point getStart() {
            return this.start;
        }

        public Point getEnd() {
            return this.end;
        }

        public double getDistance(Point p) {
            if (this.isHorizontal() && p.getX() >= this.start.getX() && p.getX() <= this.end.getX()) {
                return Math.abs(this.start.getY() - p.getY());
            }
            if (this.isVertical() && p.getY() >= this.start.getY() && p.getY() <= this.end.getY()) {
                return Math.abs(this.start.getX() - p.getX());
            }
            double d1 = this.getDistanceToStart(p);
            double d2 = this.getDistanceToEnd(p);
            return Math.min(d1, d2);
        }

        public boolean isHorizontal() {
            return Math.abs(this.start.getY() - this.end.getY()) <= 1;
        }

        public boolean isVertical() {
            return Math.abs(this.start.getX() - this.end.getX()) <= 1;
        }

        public boolean isSlanted() {
            return !this.isHorizontal() && !this.isVertical();
        }

        public double getDistanceToStart(Point p) {
            return Math.hypot(this.start.getX() - p.getX(), this.start.getY() - p.getY());
        }

        public double getDistanceToEnd(Point p) {
            return Math.hypot(this.end.getX() - p.getX(), this.end.getY() - p.getY());
        }

        public String toString() {
            return "[" + this.start.getX() + "," + this.start.getY() + "]" + " [" + this.end.getX() + "," + this.end.getY() + "]";
        }
    }

    public static class Loop {
        public Polyline circle;
        public Polyline arrow;
    }

    public static class MultiInstance {
        public Polyline line1;
        public Polyline line2;
        public Polyline line3;
    }

    public static final class RectangleIntersectsLine {
        private static final int OUT_LEFT = 1;
        private static final int OUT_TOP = 2;
        private static final int OUT_RIGHT = 4;
        private static final int OUT_BOTTOM = 8;

        private static int outcode(double pX, double pY, double rectX, double rectY, double rectWidth, double rectHeight) {
            int out = 0;
            if (rectWidth <= 0.0) {
                out |= 5;
            } else if (pX < rectX) {
                out |= 1;
            } else if (pX > rectX + rectWidth) {
                out |= 4;
            }
            if (rectHeight <= 0.0) {
                out |= 0xA;
            } else if (pY < rectY) {
                out |= 2;
            } else if (pY > rectY + rectHeight) {
                out |= 8;
            }
            return out;
        }

        /*
         * Unable to fully structure code
         */
        public static boolean intersectsLine(double lineX1, double lineY1, double lineX2, double lineY2, double rectX, double rectY, double rectWidth, double rectHeight) {
            out2 = RectangleIntersectsLine.outcode(lineX2, lineY2, rectX, rectY, rectWidth, rectHeight);
            if (out2 != 0) ** GOTO lbl18
            return true;
lbl-1000:
            // 1 sources

            {
                if ((out1 & out2) != 0) {
                    return false;
                }
                if ((out1 & 5) != 0) {
                    x = rectX;
                    if ((out1 & 4) != 0) {
                        x += rectWidth;
                    }
                    lineY1 += (x - lineX1) * (lineY2 - lineY1) / (lineX2 - lineX1);
                    lineX1 = x;
                    continue;
                }
                y = rectY;
                if ((out1 & 8) != 0) {
                    y += rectHeight;
                }
                lineX1 += (y - lineY1) * (lineX2 - lineX1) / (lineY2 - lineY1);
                lineY1 = y;
lbl18:
                // 3 sources

                ** while ((out1 = RectangleIntersectsLine.outcode((double)lineX1, (double)lineY1, (double)rectX, (double)rectY, (double)rectWidth, (double)rectHeight)) != 0)
            }
lbl19:
            // 1 sources

            return true;
        }
    }

    public static class Size {
        private int width;
        private int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class SizeTemplate {
        private Size eventSize = new Size(36, 36);
        private Size gatewaySize = new Size(50, 50);
        private Size activitySize = new Size(110, 50);
        private Size choreographySize = new Size(150, 150);
        private Size poolSize = new Size(600, 150);
        private Size participantBandSize = new Size(150, 20);

        public Size getEventSize() {
            return this.eventSize;
        }

        public void setEventSize(Size eventSize) {
            this.eventSize = eventSize;
        }

        public Size getGatewaySize() {
            return this.gatewaySize;
        }

        public void setGatewaySize(Size gatewaySize) {
            this.gatewaySize = gatewaySize;
        }

        public Size getActivitySize() {
            return this.activitySize;
        }

        public void setActivitySize(Size activitySize) {
            this.activitySize = activitySize;
        }

        public Size getChoreographySize() {
            return this.choreographySize;
        }

        public void setChoreographySize(Size choreographySize) {
            this.choreographySize = choreographySize;
            this.participantBandSize.width = choreographySize.width;
        }

        public Size getPoolSize() {
            return this.poolSize;
        }

        public void setPoolSize(Size participantSize) {
            this.poolSize = participantSize;
        }

        public Size getParticipantBandSize() {
            return new Size(this.choreographySize.width, this.participantBandSize.height);
        }

        public void setParticipantBandSize(Size participantSize) {
            this.participantBandSize = participantSize;
            this.participantBandSize.width = this.choreographySize.width;
        }
    }
}

