/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.utils.Messages;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class FixDuplicateIdsDialog
extends ListSelectionDialog {
    private static MyContentProvider contentProvider = new MyContentProvider();
    private static MyLabelProvider labelProvider = new MyLabelProvider();
    List<Tuple<EObject, EObject>> duplicates;

    public FixDuplicateIdsDialog(List<Tuple<EObject, EObject>> duplicates) {
        super(Display.getDefault().getActiveShell(), duplicates, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, Messages.FixDuplicateIdsDialog_Message);
        this.duplicates = duplicates;
    }

    public int open() {
        final int[] status = new int[1];
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] results;
                status[0] = FixDuplicateIdsDialog.super.open();
                if (status[0] == 0 && (results = FixDuplicateIdsDialog.this.getResult()).length > 0) {
                    Tuple tuple = (Tuple)results[0];
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)((EObject)tuple.getFirst()).eResource());
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            Object[] objectArray = results;
                            int n = results.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object entry = objectArray[n2];
                                Tuple tuple = (Tuple)entry;
                                EObject object = (EObject)tuple.getSecond();
                                EAttribute idFeature = object.eClass().getEIDAttribute();
                                Object id = object.eGet((EStructuralFeature)idFeature);
                                Object uniqueId = FixDuplicateIdsDialog.this.makeUniqueId(object, id);
                                object.eSet((EStructuralFeature)idFeature, uniqueId);
                                ++n2;
                            }
                        }
                    });
                }
            }
        });
        return status[0];
    }

    private Object makeUniqueId(EObject object, Object id) {
        int i = 1;
        Object uniqueId = id;
        EObject dup = null;
        do {
            if ((dup = this.findDuplicateId(object, uniqueId)) == null) continue;
            uniqueId = id + "_" + i++;
        } while (dup != null);
        return uniqueId;
    }

    private EObject findDuplicateId(EObject object, Object id) {
        if (object != null && id != null) {
            Resource resource = object.eResource();
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                Object existingId;
                EStructuralFeature f;
                EObject o = (EObject)iter.next();
                if (o == object || (f = o.eClass().getEStructuralFeature("id")) == null || !id.equals(existingId = o.eGet(f))) continue;
                return o;
            }
        }
        return null;
    }

    private static class MyContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List duplicates = (List)inputElement;
            return duplicates.toArray();
        }
    }

    private static class MyLabelProvider
    implements ILabelProvider {
        private MyLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            Tuple tuple = (Tuple)element;
            EObject o1 = (EObject)tuple.getFirst();
            EObject o2 = (EObject)tuple.getSecond();
            return NLS.bind((String)Messages.FixDuplicateIdsDialog_Duplicate_ID, (Object)ModelUtil.getLongDisplayName(o1), (Object)ModelUtil.getLongDisplayName(o2));
        }
    }
}

