/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BusinessObjectUtil {
    public static boolean containsElementOfType(PictogramElement elem, Class clazz) {
        if (elem.getLink() == null) {
            return false;
        }
        if (AnchorUtil.isConnectionPoint(elem)) {
            elem = AnchorUtil.getConnectionPointOwner((Shape)elem);
        }
        EList businessObjs = elem.getLink().getBusinessObjects();
        for (EObject eObject : businessObjs) {
            if (!clazz.isInstance(eObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsChildElementOfType(PictogramElement root, Class clazz) {
        if (AnchorUtil.isConnectionPoint(root)) {
            root = AnchorUtil.getConnectionPointOwner((Shape)root);
        }
        if (root instanceof ContainerShape) {
            ContainerShape rootContainer = (ContainerShape)root;
            for (Shape currentShape : rootContainer.getChildren()) {
                if (!BusinessObjectUtil.containsElementOfType((PictogramElement)currentShape, clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends EObject> T getFirstElementOfType(PictogramElement elem, Class<T> clazz) {
        return BusinessObjectUtil.getFirstElementOfType(elem, clazz, false);
    }

    public static <T extends EObject> T getFirstElementOfType(PictogramElement elem, Class<T> clazz, boolean searchParents) {
        if (elem == null || elem.getLink() == null) {
            if (searchParents) {
                while (elem != null && elem.getLink() == null && elem.eContainer() instanceof PictogramElement) {
                    elem = (PictogramElement)elem.eContainer();
                }
            }
            if (elem == null || elem.getLink() == null) {
                return null;
            }
        }
        if (AnchorUtil.isConnectionPoint(elem)) {
            elem = AnchorUtil.getConnectionPointOwner((Shape)elem);
        }
        EList businessObjs = elem.getLink().getBusinessObjects();
        for (EObject eObject : businessObjs) {
            if (!clazz.isInstance(eObject)) continue;
            return (T)eObject;
        }
        return null;
    }

    public static BaseElement getFirstBaseElement(PictogramElement pe) {
        return BusinessObjectUtil.getFirstElementOfType(pe, BaseElement.class);
    }

    public static PictogramElement getFirstBaseElementFromDiagram(Diagram diagram, BaseElement e) {
        PictogramElement foundElem = null;
        IPeService peService = Graphiti.getPeService();
        block0: for (Diagram d : BusinessObjectUtil.getAllDiagrams(diagram)) {
            Collection elements = peService.getAllContainedPictogramElements((PictogramElement)d);
            for (PictogramElement pe : elements) {
                BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType(pe, e.getClass());
                if (be == null || !be.equals(e)) continue;
                foundElem = pe;
                continue block0;
            }
        }
        return foundElem;
    }

    public static PictogramElement getPictogramElementFromDiagram(Diagram diagram, BPMNShape bpmnShape) {
        PictogramElement foundElem = null;
        IPeService peService = Graphiti.getPeService();
        block0: for (Diagram d : BusinessObjectUtil.getAllDiagrams(diagram)) {
            Collection elements = peService.getAllContainedPictogramElements((PictogramElement)d);
            for (PictogramElement pe : elements) {
                BPMNShape s = BusinessObjectUtil.getFirstElementOfType(pe, BPMNShape.class);
                if (s == null || !s.equals(bpmnShape)) continue;
                foundElem = pe;
                continue block0;
            }
        }
        return foundElem;
    }

    public static PictogramElement getPictogramElementForSelection(ISelection selection) {
        Object o;
        EditPart editPart = BusinessObjectUtil.getEditPartForSelection(selection);
        if (editPart != null && editPart.getModel() instanceof PictogramElement) {
            return (PictogramElement)editPart.getModel();
        }
        if (editPart instanceof AbstractTreeEditPart) {
            return (PictogramElement)editPart.getAdapter(PictogramElement.class);
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof PictogramElement) {
            return (PictogramElement)o;
        }
        return null;
    }

    public static EObject getBusinessObjectForSelection(ISelection selection) {
        PictogramElement pe = BusinessObjectUtil.getPictogramElementForSelection(selection);
        if (pe != null) {
            return BusinessObjectUtil.getBusinessObjectForPictogramElement(pe);
        }
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            EditPart editPart = null;
            if (firstElement instanceof EditPart) {
                editPart = (EditPart)firstElement;
                if (editPart.getModel() instanceof EObject) {
                    return (EObject)editPart.getModel();
                }
            } else if (firstElement instanceof EObject) {
                return (EObject)firstElement;
            }
        }
        return null;
    }

    public static EObject getBusinessObjectForPictogramElement(PictogramElement pe) {
        if (pe != null) {
            EObject be;
            if (pe instanceof ConnectionDecorator) {
                pe = ((ConnectionDecorator)pe).getConnection();
            }
            if ((be = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof EObject) {
                return be;
            }
        }
        return null;
    }

    public static EditPart getEditPartForSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty()) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            EditPart editPart = null;
            if (firstElement instanceof EditPart) {
                editPart = (EditPart)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                editPart = (EditPart)((IAdaptable)firstElement).getAdapter(EditPart.class);
            }
            return editPart;
        }
        return null;
    }

    public static boolean isConnection(Class be) {
        return be == SequenceFlow.class || be == Association.class || be == MessageFlow.class || be == DataInputAssociation.class || be == DataOutputAssociation.class || be == ConversationLink.class;
    }

    public static List<Diagram> getAllDiagrams(Diagram diagram) {
        ArrayList<Diagram> list = new ArrayList<Diagram>();
        list.add(diagram);
        Resource resource = diagram.eResource();
        for (EObject o : resource.getContents()) {
            if (!(o instanceof Diagram) || o == diagram) continue;
            list.add((Diagram)o);
        }
        return list;
    }
}

