/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.Collection;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeature;

public class ModelEnablementDescriptor
extends BaseRuntimeDescriptor {
    private ModelEnablements modelEnablements;
    private ModelUtil.Bpmn2DiagramType diagramType;
    private String profile;

    private ModelEnablementDescriptor() {
    }

    public ModelEnablementDescriptor(TargetRuntime rt) {
        super(rt);
        this.modelEnablements = new ModelEnablements(rt, null, null);
    }

    public void setDiagramType(ModelUtil.Bpmn2DiagramType type) {
        this.diagramType = type;
    }

    public ModelUtil.Bpmn2DiagramType getDiagramType() {
        return this.diagramType;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setEnabled(EClass eClass, boolean enabled) {
        this.modelEnablements.setEnabled(eClass, enabled);
    }

    public void setEnabled(String className, boolean enabled) {
        this.modelEnablements.setEnabled(className, enabled);
    }

    public void setEnabled(String className, String featureName, boolean enabled) {
        this.modelEnablements.setEnabled(className, featureName, enabled);
    }

    public void initializeFromTargetRuntime(TargetRuntime rt, ModelUtil.Bpmn2DiagramType type, String profile) {
        ModelEnablementDescriptor med = rt.getModelEnablements(type, profile);
        Collection<String> enabledClasses = med.modelEnablements.getAllEnabledClasses();
        for (String c : enabledClasses) {
            Collection<String> enabledFeatures = med.modelEnablements.getAllEnabledFeatures(c);
            for (String f : enabledFeatures) {
                this.setEnabled(c, f, true);
            }
        }
    }

    public boolean isEnabled(String className, String featureName) {
        return this.modelEnablements.isEnabled(className, featureName);
    }

    public boolean isEnabled(EClass eClass, EStructuralFeature feature) {
        return this.modelEnablements.isEnabled(eClass, feature);
    }

    public boolean isEnabled(EClass eClass) {
        return this.modelEnablements.isEnabled(eClass);
    }

    public boolean isEnabled(String className) {
        return this.modelEnablements.isEnabled(className);
    }

    public boolean isEnabled(IFeature feature) {
        return this.modelEnablements.isEnabled(feature);
    }

    public Collection<String> getAllEnabled() {
        return this.modelEnablements.getAllEnabled();
    }
}

