/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;

public class Bpmn2TabDescriptor
extends AbstractTabDescriptor {
    protected String id;
    protected String category;
    protected String label;
    protected String afterTab = null;
    protected String replaceTab = null;
    protected boolean indented = false;
    protected Image image = null;
    protected boolean popup = true;

    public Bpmn2TabDescriptor(IConfigurationElement e) {
        this.id = e.getAttribute("id");
        this.category = e.getAttribute("category");
        if (this.category == null || this.category.isEmpty()) {
            this.category = "BPMN2";
        }
        this.label = e.getAttribute("label");
        this.afterTab = e.getAttribute("afterTab");
        this.replaceTab = e.getAttribute("replaceTab");
        String s = e.getAttribute("indented");
        this.indented = s != null && s.trim().equalsIgnoreCase("true");
        s = e.getAttribute("popup");
        if (s != null && s.trim().equalsIgnoreCase("false")) {
            this.popup = false;
        }
    }

    public Bpmn2TabDescriptor(String id, String category, String label) {
        this.id = id;
        if (category == null || category.isEmpty()) {
            category = "BPMN2";
        }
        this.category = category;
        this.label = label;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public String getAfterTab() {
        if (this.afterTab == null || this.afterTab.trim().length() == 0) {
            return super.getAfterTab();
        }
        return this.afterTab;
    }

    public Image getImage() {
        if (this.image == null) {
            return super.getImage();
        }
        return this.image;
    }

    public TabContents createTab() {
        return super.createTab();
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    public void setSectionDescriptors(List sectionDescriptors) {
        super.setSectionDescriptors(sectionDescriptors);
    }

    public boolean isIndented() {
        return this.indented;
    }

    public Object clone() {
        Bpmn2TabDescriptor td = new Bpmn2TabDescriptor(this.id, this.category, this.label);
        td.afterTab = this.afterTab;
        td.replaceTab = this.replaceTab;
        if (this.image != null) {
            td.image = new Image((Device)Display.getDefault(), this.image, 0);
        }
        td.indented = this.indented;
        return td;
    }

    public Bpmn2TabDescriptor copy() {
        Bpmn2TabDescriptor td = new Bpmn2TabDescriptor(this.id, this.category, this.label);
        td.id = String.valueOf(td.id) + td.hashCode();
        td.afterTab = this.afterTab;
        td.replaceTab = this.replaceTab;
        if (this.image != null) {
            td.image = new Image((Device)Display.getDefault(), this.image, 0);
        }
        td.indented = this.indented;
        td.popup = this.popup;
        td.image = this.image;
        for (Bpmn2SectionDescriptor sd : this.getSectionDescriptors()) {
            td.getSectionDescriptors().add(new Bpmn2SectionDescriptor(td, sd));
        }
        return td;
    }

    public String getReplaceTab() {
        if (this.replaceTab == null || this.replaceTab.trim().length() == 0) {
            return null;
        }
        return this.replaceTab;
    }

    public boolean isReplacementForTab(String id) {
        String replacements = this.getReplaceTab();
        if (replacements != null) {
            String[] rep;
            String[] stringArray = rep = replacements.split(" ");
            int n = rep.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                if (r.equals(id)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

