/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.preferences;

import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.ColorUtil;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ShapeStyle {
    public static IColorConstant DEFAULT_COLOR = new ColorConstant(212, 231, 248);
    public static String DEFAULT_FONT_STRING = "arial,10,-,-";
    IColorConstant shapeBackground;
    IColorConstant shapePrimarySelectedColor;
    IColorConstant shapeSecondarySelectedColor;
    IColorConstant shapeForeground;
    Font textFont;
    IColorConstant textColor;
    RoutingStyle routingStyle = RoutingStyle.Manhattan;
    boolean defaultSize;
    boolean dirty;

    public ShapeStyle() {
        this.setDefaultColors(DEFAULT_COLOR);
        this.textFont = ShapeStyle.stringToFont(DEFAULT_FONT_STRING);
    }

    public ShapeStyle(ShapeStyle other) {
        this(ShapeStyle.encode(other));
    }

    public ShapeStyle(String foreground, String background, String textColor, String font) {
        this.shapeBackground = ShapeStyle.stringToColor(background);
        this.setDefaultColors(this.shapeBackground);
        if (foreground != null && !foreground.isEmpty()) {
            this.shapeForeground = ShapeStyle.stringToColor(foreground);
        }
        if (textColor != null && !textColor.isEmpty()) {
            this.textColor = ShapeStyle.stringToColor(textColor);
        }
        if (font == null || font.isEmpty()) {
            font = DEFAULT_FONT_STRING;
        }
        this.textFont = ShapeStyle.stringToFont(font);
        this.defaultSize = false;
    }

    protected ShapeStyle(String s) {
        String[] a = s.trim().split(";");
        if (a.length > 0) {
            this.shapeBackground = ShapeStyle.stringToColor(a[0]);
        }
        if (a.length > 1) {
            this.shapePrimarySelectedColor = ShapeStyle.stringToColor(a[1]);
        }
        if (a.length > 2) {
            this.shapeSecondarySelectedColor = ShapeStyle.stringToColor(a[2]);
        }
        if (a.length > 3) {
            this.shapeForeground = ShapeStyle.stringToColor(a[3]);
        }
        if (a.length > 4) {
            this.textFont = ShapeStyle.stringToFont(a[4]);
        }
        if (a.length > 5) {
            this.textColor = ShapeStyle.stringToColor(a[5]);
        }
        this.defaultSize = a.length > 6 ? ShapeStyle.stringToBoolean(a[6]) : false;
        if (a.length > 7) {
            try {
                this.routingStyle = RoutingStyle.valueOf(a[7]);
            }
            catch (Exception exception) {
                this.routingStyle = RoutingStyle.ManualBendpoint;
            }
        } else {
            this.routingStyle = RoutingStyle.ManualBendpoint;
        }
    }

    public void setDefaultColors(IColorConstant defaultColor) {
        this.setShapeBackground(defaultColor);
        this.setShapePrimarySelectedColor(StyleUtil.shiftColor(defaultColor, 32));
        this.setShapeSecondarySelectedColor(StyleUtil.shiftColor(defaultColor, -32));
        this.setShapeForeground(StyleUtil.shiftColor(defaultColor, -128));
        this.setTextColor(StyleUtil.shiftColor(defaultColor, -128));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public IColorConstant getShapeBackground() {
        return this.shapeBackground;
    }

    public void setShapeBackground(IColorConstant shapeDefaultColor) {
        if (!ShapeStyle.compare(this.shapeBackground, shapeDefaultColor)) {
            this.shapeBackground = shapeDefaultColor;
            this.setDirty(true);
        }
    }

    public IColorConstant getShapePrimarySelectedColor() {
        return this.shapePrimarySelectedColor;
    }

    public void setShapePrimarySelectedColor(IColorConstant shapePrimarySelectedColor) {
        if (!ShapeStyle.compare(this.shapePrimarySelectedColor, shapePrimarySelectedColor)) {
            this.shapePrimarySelectedColor = shapePrimarySelectedColor;
            this.setDirty(true);
        }
    }

    public IColorConstant getShapeSecondarySelectedColor() {
        return this.shapeSecondarySelectedColor;
    }

    public void setShapeSecondarySelectedColor(IColorConstant shapeSecondarySelectedColor) {
        if (!ShapeStyle.compare(this.shapeSecondarySelectedColor, shapeSecondarySelectedColor)) {
            this.shapeSecondarySelectedColor = shapeSecondarySelectedColor;
            this.setDirty(true);
        }
    }

    public IColorConstant getShapeForeground() {
        return this.shapeForeground;
    }

    public void setShapeForeground(IColorConstant shapeBorderColor) {
        if (!ShapeStyle.compare(this.shapeForeground, shapeBorderColor)) {
            this.shapeForeground = shapeBorderColor;
            this.setDirty(true);
        }
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        if (!ShapeStyle.compare(this.textFont, textFont)) {
            this.textFont = textFont;
            this.setDirty(true);
        }
    }

    public IColorConstant getTextColor() {
        return this.textColor;
    }

    public void setTextColor(IColorConstant textColor) {
        if (!ShapeStyle.compare(this.textColor, textColor)) {
            this.textColor = textColor;
            this.setDirty(true);
        }
    }

    public RoutingStyle getRoutingStyle() {
        return this.routingStyle;
    }

    public void setRoutingStyle(RoutingStyle routingStyle) {
        if (this.routingStyle != routingStyle) {
            this.routingStyle = routingStyle;
            this.setDirty(true);
        }
    }

    public boolean isDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(boolean b) {
        if (this.defaultSize != b) {
            this.defaultSize = b;
            this.setDirty(true);
        }
    }

    public static String colorToString(IColorConstant c) {
        return new String(String.valueOf(String.format("%02X", c.getRed())) + String.format("%02X", c.getGreen()) + String.format("%02X", c.getBlue()));
    }

    public static IColorConstant stringToColor(String s) {
        if (s.contains(",")) {
            String[] a = s.split(",");
            int r = Integer.parseInt(a[0]);
            int g = Integer.parseInt(a[1]);
            int b = Integer.parseInt(a[2]);
            return new ColorConstant(r, g, b);
        }
        if (s.length() < 6) {
            return new ColorConstant(0, 0, 0);
        }
        return new ColorConstant(ColorUtil.getRedFromHex((String)s), ColorUtil.getGreenFromHex((String)s), ColorUtil.getBlueFromHex((String)s));
    }

    public static String booleanToString(boolean b) {
        return b ? "1" : "0";
    }

    public static boolean stringToBoolean(String s) {
        return "1".equals(s);
    }

    public static RGB colorToRGB(IColorConstant c) {
        return new RGB(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static IColorConstant RGBToColor(RGB rgb) {
        return new ColorConstant(rgb.red, rgb.green, rgb.blue);
    }

    public static String fontToString(Font f) {
        return new String(String.valueOf(f.getName()) + "," + f.getSize() + "," + (f.isItalic() ? "I" : "-") + "," + (f.isBold() ? "B" : "-"));
    }

    public static Font stringToFont(String s) {
        String[] a = s.split(",");
        Font f = StylesFactory.eINSTANCE.createFont();
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Name(), (Object)a[0]);
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Size(), (Object)Integer.valueOf(a[1]));
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Italic(), (Object)a[2].equals("I"));
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Bold(), (Object)a[3].equals("B"));
        return f;
    }

    public static FontData fontToFontData(Font f) {
        int style = 0;
        if (f.isItalic()) {
            style |= 2;
        }
        if (f.isBold()) {
            style |= 1;
        }
        return new FontData(f.getName(), f.getSize(), style);
    }

    public static Font fontDataToFont(FontData fd) {
        Font f = StylesFactory.eINSTANCE.createFont();
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Name(), (Object)fd.getName());
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Size(), (Object)fd.getHeight());
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Italic(), (Object)((fd.getStyle() & 2) != 0 ? 1 : 0));
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Bold(), (Object)((fd.getStyle() & 1) != 0 ? 1 : 0));
        return f;
    }

    public static String encode(ShapeStyle sp) {
        if (sp == null) {
            return ShapeStyle.encode(new ShapeStyle());
        }
        return new String(String.valueOf(ShapeStyle.colorToString(sp.shapeBackground)) + ";" + ShapeStyle.colorToString(sp.shapePrimarySelectedColor) + ";" + ShapeStyle.colorToString(sp.shapeSecondarySelectedColor) + ";" + ShapeStyle.colorToString(sp.shapeForeground) + ";" + ShapeStyle.fontToString(sp.textFont) + ";" + ShapeStyle.colorToString(sp.textColor) + ";" + ShapeStyle.booleanToString(sp.defaultSize) + ";" + sp.routingStyle.name());
    }

    public static ShapeStyle decode(String s) {
        if (s == null || s.trim().split(";").length < 6) {
            return new ShapeStyle();
        }
        return new ShapeStyle(s);
    }

    public static boolean compare(IColorConstant c1, IColorConstant c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
    }

    public static boolean compare(Font f1, Font f2) {
        String s1 = ShapeStyle.fontToString(f1);
        String s2 = ShapeStyle.fontToString(f2);
        return s1.equals(s2);
    }

    public static boolean compare(ShapeStyle s1, ShapeStyle s2) {
        return ShapeStyle.compare(s1.shapeBackground, s2.shapeBackground) || ShapeStyle.compare(s1.shapePrimarySelectedColor, s2.shapePrimarySelectedColor) || ShapeStyle.compare(s1.shapeSecondarySelectedColor, s2.shapeSecondarySelectedColor) || ShapeStyle.compare(s1.shapeForeground, s2.shapeForeground) || ShapeStyle.compare(s1.textFont, s2.textFont) || ShapeStyle.compare(s1.textColor, s2.textColor) || s1.defaultSize != s2.defaultSize;
    }

    public static enum RoutingStyle {
        ManualBendpoint,
        AutomaticBendpoint,
        Manhattan;

    }
}

