/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.preferences;

import java.util.ArrayList;
import org.eclipse.bpmn2.modeler.core.AbstractPropertyChangeListenerProvider;
import org.eclipse.emf.ecore.ENamedElement;

public class ModelEnablementTreeEntry
extends AbstractPropertyChangeListenerProvider {
    private String name;
    private ENamedElement element;
    private Boolean enabled;
    private ModelEnablementTreeEntry parent;
    private ArrayList<ModelEnablementTreeEntry> children;
    private ArrayList<ModelEnablementTreeEntry> friends;
    private static ArrayList<ModelEnablementTreeEntry> EMPTY_LIST = new ArrayList();

    public ModelEnablementTreeEntry() {
    }

    public ModelEnablementTreeEntry(ENamedElement element, ModelEnablementTreeEntry parent) {
        this.setElement(element);
        this.parent = parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.element != null) {
            return this.element.getName();
        }
        return this.name == null ? "" : this.name;
    }

    public String getPreferenceName() {
        if (this.parent == null || this.parent.getElement() == null) {
            return this.getName();
        }
        return String.valueOf(this.parent.getPreferenceName()) + "." + this.getName();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setSubtreeEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        for (ModelEnablementTreeEntry child : this.getChildren()) {
            child.setSubtreeEnabled(enabled);
        }
    }

    public int getSubtreeSize() {
        return ModelEnablementTreeEntry.getSubtreeSize(this);
    }

    private static int getSubtreeSize(ModelEnablementTreeEntry parent) {
        int size = 0;
        for (ModelEnablementTreeEntry child : parent.getChildren()) {
            ++size;
            size += ModelEnablementTreeEntry.getSubtreeSize(child);
        }
        return size;
    }

    public int getSubtreeEnabledCount() {
        return ModelEnablementTreeEntry.getSubtreeEnabledCount(this);
    }

    private static int getSubtreeEnabledCount(ModelEnablementTreeEntry parent) {
        int count = 0;
        for (ModelEnablementTreeEntry child : parent.getChildren()) {
            if (child.getEnabled().booleanValue()) {
                ++count;
            }
            count += ModelEnablementTreeEntry.getSubtreeEnabledCount(child);
        }
        return count;
    }

    public void setElement(ENamedElement element) {
        if (element != null) {
            this.name = element.getName();
        }
        this.element = element;
    }

    public ENamedElement getElement() {
        return this.element;
    }

    public void setChildren(ArrayList<ModelEnablementTreeEntry> children) {
        this.children = children;
    }

    public ArrayList<ModelEnablementTreeEntry> getChildren() {
        if (this.children == null) {
            return EMPTY_LIST;
        }
        return this.children;
    }

    public void setParent(ModelEnablementTreeEntry parent) {
        this.parent = parent;
    }

    public ModelEnablementTreeEntry getParent() {
        return this.parent;
    }

    public String toString() {
        return "ModelEnablementTreeEntry [element=" + this.getName() + ", enabled=" + this.enabled + ", children=" + this.children + ", parent=" + (this.parent == null ? "null" : this.parent.getName()) + "]";
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public boolean hasFriends() {
        return this.friends != null && this.friends.size() > 0;
    }

    public ArrayList<ModelEnablementTreeEntry> getFriends() {
        if (this.friends == null) {
            return EMPTY_LIST;
        }
        return this.friends;
    }

    public void addFriend(ModelEnablementTreeEntry friend) {
        if (friend != null) {
            if (this.friends == null) {
                this.friends = new ArrayList();
            }
            if (!this.friends.contains(friend)) {
                this.friends.add(friend);
            }
        }
    }
}

