/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

public class TableProvider
implements ITableLabelProvider,
ICellModifier {
    protected HashMap propertyToLabelProvider = new HashMap();
    protected HashMap propertyToCellModifier = new HashMap();
    protected ArrayList labelProviderListeners = new ArrayList();
    protected String[] columnProperties;

    public void setColumnProperties(String[] columnProperties) {
        this.columnProperties = columnProperties;
    }

    public String[] getColumnProperties() {
        return this.columnProperties;
    }

    public String getColumnProperty(int index) {
        return this.columnProperties[index];
    }

    public void unregister(String property) {
        IBaseLabelProvider oldLp = (IBaseLabelProvider)this.propertyToLabelProvider.remove(property);
        this.propertyToCellModifier.remove(property);
        if (oldLp != null) {
            Iterator it = this.labelProviderListeners.iterator();
            while (it.hasNext()) {
                oldLp.removeListener((ILabelProviderListener)it.next());
            }
        }
    }

    public void register(String property, IBaseLabelProvider lp, ICellModifier cm) {
        this.unregister(property);
        Iterator it = this.labelProviderListeners.iterator();
        while (it.hasNext()) {
            lp.addListener((ILabelProviderListener)it.next());
        }
        this.propertyToLabelProvider.put(property, lp);
        this.propertyToCellModifier.put(property, cm);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Object lp = this.propertyToLabelProvider.get(this.columnProperties[columnIndex]);
        if (lp instanceof ITableLabelProvider) {
            return ((ITableLabelProvider)lp).getColumnImage(element, columnIndex);
        }
        if (lp instanceof ILabelProvider) {
            return ((ILabelProvider)lp).getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object lp = this.propertyToLabelProvider.get(this.columnProperties[columnIndex]);
        if (lp instanceof ITableLabelProvider) {
            return ((ITableLabelProvider)lp).getColumnText(element, columnIndex);
        }
        if (lp instanceof ILabelProvider) {
            return ((ILabelProvider)lp).getText(element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add(listener);
        Iterator it = this.propertyToLabelProvider.values().iterator();
        while (it.hasNext()) {
            ((IBaseLabelProvider)it.next()).addListener(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add(listener);
        Iterator it = this.propertyToLabelProvider.values().iterator();
        while (it.hasNext()) {
            ((IBaseLabelProvider)it.next()).removeListener(listener);
        }
    }

    public void dispose() {
        Iterator it = this.propertyToLabelProvider.values().iterator();
        while (it.hasNext()) {
            ((IBaseLabelProvider)it.next()).dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        Iterator it = this.propertyToLabelProvider.values().iterator();
        while (it.hasNext()) {
            if (!((IBaseLabelProvider)it.next()).isLabelProperty(element, property)) continue;
            return true;
        }
        return false;
    }

    public boolean canModify(Object element, String property) {
        ICellModifier cm = (ICellModifier)this.propertyToCellModifier.get(property);
        if (cm != null) {
            return cm.canModify(element, property);
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        ICellModifier cm = (ICellModifier)this.propertyToCellModifier.get(property);
        if (cm != null) {
            return cm.getValue(element, property);
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        ICellModifier cm;
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if ((cm = (ICellModifier)this.propertyToCellModifier.get(property)) != null) {
            cm.modify(element, property, value);
            return;
        }
    }
}

