/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class TextAndButtonObjectEditor
extends TextObjectEditor {
    protected static int ID_DEFAULT_BUTTON = 0;
    protected static int ID_ADD_BUTTON = 1;
    protected static int ID_REMOVE_BUTTON = 2;
    protected Button defaultButton;
    protected Button addButton;
    protected Button removeButton;

    public TextAndButtonObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        super.createControl(composite, label, style);
        this.text.setEditable(false);
        GridData textLayoutData = (GridData)this.text.getLayoutData();
        textLayoutData.horizontalSpan = 1;
        boolean multiLine = (style & 2) != 0;
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        buttons.setLayout((Layout)new FillLayout((style & 2) != 0 ? 512 : 256));
        if (this.canAdd()) {
            this.addButton = this.getToolkit().createButton(buttons, null, 8);
            this.addButton.setImage(Activator.getDefault().getImage("20/add.png"));
            if (multiLine) {
                textLayoutData.heightHint += 25;
            }
        }
        if (this.canRemove()) {
            this.removeButton = this.getToolkit().createButton(buttons, null, 8);
            this.removeButton.setImage(Activator.getDefault().getImage("20/remove.png"));
            if (multiLine) {
                textLayoutData.heightHint += 25;
            }
        }
        this.defaultButton = this.getToolkit().createButton(buttons, null, 8);
        this.defaultButton.setImage(Activator.getDefault().getImage("20/edit.png"));
        this.updateText();
        SelectionAdapter editListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int id = ID_DEFAULT_BUTTON;
                if (e.widget == TextAndButtonObjectEditor.this.addButton) {
                    id = ID_ADD_BUTTON;
                } else if (e.widget == TextAndButtonObjectEditor.this.removeButton) {
                    id = ID_REMOVE_BUTTON;
                }
                TextAndButtonObjectEditor.this.buttonClicked(id);
            }
        };
        this.defaultButton.addSelectionListener((SelectionListener)editListener);
        if (this.canAdd()) {
            this.addButton.addSelectionListener((SelectionListener)editListener);
        }
        if (this.canRemove()) {
            this.removeButton.addSelectionListener((SelectionListener)editListener);
        }
        return this.text;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.dispose();
            this.defaultButton = null;
        }
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.dispose();
            this.addButton = null;
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.dispose();
            this.removeButton = null;
        }
    }

    protected abstract void buttonClicked(int var1);
}

