/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.lang.reflect.Field;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FeatureEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.JavaReflectionUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ObjectEditor
implements INotifyChangedListener {
    protected EObject object;
    protected EStructuralFeature feature;
    protected AbstractDetailComposite parent;
    private Label label;
    protected ControlDecoration decoration;
    protected int style;
    protected Class messages;
    protected boolean isWidgetUpdating = false;

    public ObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        this.parent = parent;
        this.object = object;
        this.feature = feature;
        this.style = 0;
        this.messages = JavaReflectionUtil.findClass((Object)parent, "Messages");
    }

    protected abstract Control createControl(Composite var1, String var2, int var3);

    public void setStyle(int style) {
        this.style = style;
    }

    public Control createControl(Composite composite, String label) {
        Control c = this.createControl(composite, label, this.style);
        c.setData("notify.changed.listener", (Object)this);
        return c;
    }

    public Control createControl(String label) {
        Control c = this.createControl(this.parent, label, this.style);
        c.setData("notify.changed.listener", (Object)this);
        return c;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EObject getObject() {
        return this.object;
    }

    public void setObject(EObject object) {
        this.object = object;
    }

    public void setObject(EObject object, EStructuralFeature feature) {
        this.object = object;
        this.feature = feature;
    }

    protected FormToolkit getToolkit() {
        return this.parent.getToolkit();
    }

    protected DiagramEditor getDiagramEditor() {
        return this.parent.getDiagramEditor();
    }

    protected Diagram getDiagram() {
        return this.getDiagramEditor().getDiagramTypeProvider().getDiagram();
    }

    protected Label createLabel(Composite parent, String name) {
        this.label = this.getToolkit().createLabel(parent, name);
        this.label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.updateLabelDecorator();
        return this.label;
    }

    public Label getLabel() {
        return this.label;
    }

    private boolean statusApplies(IStatus status) {
        if (status instanceof ConstraintStatus) {
            ConstraintStatus cs = (ConstraintStatus)status;
            for (EObject f : cs.getResultLocus()) {
                if (!(f instanceof EStructuralFeature) || f != this.feature) continue;
                return true;
            }
        }
        return false;
    }

    protected FeatureEditingDialog createFeatureEditingDialog(EObject value) {
        return new FeatureEditingDialog(this.getDiagramEditor(), this.object, this.feature, value);
    }

    protected String getToolTipText() {
        String text = "";
        if (this.messages != null) {
            try {
                String fieldName = "UI_" + this.object.eClass().getName() + "_" + this.feature.getName() + "_description";
                Field field = this.messages.getField(fieldName);
                text = String.valueOf(text) + (String)field.get(null);
            }
            catch (Exception exception) {
                try {
                    String fieldName = "UI_Any_" + this.feature.getName() + "_description";
                    Field field = this.messages.getField(fieldName);
                    text = String.valueOf(text) + (String)field.get(null);
                }
                catch (Exception exception2) {}
            }
            if (text == null || text.isEmpty()) {
                text = NLS.bind((String)Messages.ObjectEditor_No_Description, (Object)this.label.getText());
            }
        }
        return text;
    }

    protected void updateLabelDecorator() {
        String tooltip = this.label.getToolTipText();
        if (tooltip == null && this.object != null && this.feature != null) {
            this.label.setToolTipText(this.getToolTipText());
        }
        boolean applies = false;
        String image = null;
        String text = null;
        ValidationStatusAdapter statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)this.object, ValidationStatusAdapter.class);
        if (statusAdapter != null) {
            IStatus status = statusAdapter.getValidationStatus();
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus s = iStatusArray[n2];
                    if (this.statusApplies(s)) {
                        applies = true;
                        break;
                    }
                    ++n2;
                }
            } else if (this.statusApplies(status)) {
                applies = true;
            }
            if (applies) {
                text = status.getMessage();
                switch (status.getSeverity()) {
                    case 1: {
                        image = "IMG_OBJS_INFO_TSK";
                        break;
                    }
                    case 2: {
                        image = "IMG_DEC_FIELD_WARNING";
                        break;
                    }
                    case 4: {
                        image = "IMG_DEC_FIELD_ERROR";
                        break;
                    }
                }
            }
        }
        if (applies) {
            if (this.decoration == null) {
                this.decoration = new ControlDecoration((Control)this.label, 16512);
            }
            this.decoration.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(image));
            this.decoration.show();
            this.decoration.setDescriptionText(text);
        } else if (this.decoration != null) {
            this.decoration.hide();
            this.decoration.dispose();
            this.decoration = null;
        }
    }

    protected boolean setValue(Object result) {
        TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
        boolean success = ModelUtil.setValue(domain, this.object, this.feature, result);
        if (!success) {
            ErrorUtils.showErrorMessage(NLS.bind((String)Messages.ObjectEditor_Set_Error_Message, (Object[])new Object[]{ModelUtil.getDisplayName(this.object), ModelUtil.getLabel(this.object, this.feature), ModelUtil.getDisplayName(result)}));
            return false;
        }
        return true;
    }

    public abstract Object getValue();

    public void notifyChanged(Notification notification) {
        this.updateLabelDecorator();
    }

    public void setVisible(boolean visible) {
        this.label.setVisible(visible);
        GridData data = (GridData)this.label.getLayoutData();
        data.exclude = !visible;
    }

    public boolean isVisible() {
        return this.label.isVisible();
    }

    public void dispose() {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
            this.label = null;
        }
        if (this.decoration != null) {
            this.decoration.dispose();
            this.decoration = null;
        }
    }

    public Control getControl() {
        return this.label;
    }

    protected boolean canEdit() {
        return ModelUtil.canEdit(this.object, this.feature);
    }

    protected boolean canCreateNew() {
        return ModelUtil.canCreateNew(this.object, this.feature);
    }

    protected boolean canEditInline() {
        return ModelUtil.canEditInline(this.object, this.feature);
    }

    protected boolean canSetNull() {
        return ModelUtil.canSetNull(this.object, this.feature);
    }

    protected boolean canAdd() {
        return false;
    }

    protected boolean canRemove() {
        return false;
    }
}

