/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FeatureEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.MultivalueObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeatureListObjectEditor
extends MultivalueObjectEditor {
    Text text;
    List<EObject> references;
    Composite buttons;
    Button editButton;
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public FeatureListObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature, (EClass)feature.getEType());
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        this.createLabel(composite, label);
        this.text = this.getToolkit().createText(composite, "");
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.setEditable(false);
        this.references = this.getValue();
        this.updateTextField();
        boolean canEdit = this.canEdit();
        boolean canCreateNew = this.canCreateNew();
        if (canEdit || canCreateNew) {
            this.buttons = this.getToolkit().createComposite(composite);
            this.buttons.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.buttons.setLayout((Layout)new FillLayout(256));
            if (canCreateNew) {
                Button createButton = this.getToolkit().createButton(this.buttons, null, 8);
                createButton.setImage(Activator.getDefault().getImage("20/add.png"));
                createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FeatureEditingDialog dialog = FeatureListObjectEditor.this.createFeatureEditingDialog(null);
                        if (dialog.open() == 0) {
                            FeatureListObjectEditor.this.updateEObject(dialog.getNewObject());
                            FeatureListObjectEditor.this.updateTextField();
                        }
                    }
                });
            }
            if (canEdit) {
                this.editButton = this.getToolkit().createButton(this.buttons, null, 8);
                this.editButton.setImage(Activator.getDefault().getImage("20/edit.png"));
                this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Hashtable<String, Object> choices = FeatureListObjectEditor.this.getChoiceOfValues(FeatureListObjectEditor.this.object, FeatureListObjectEditor.this.feature);
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.addAll(choices.values());
                        FeatureEditorDialog featureEditorDialog = new FeatureEditorDialog(FeatureListObjectEditor.this.parent.getShell(), (ILabelProvider)new ListLabelProvider(), FeatureListObjectEditor.this.object, FeatureListObjectEditor.this.feature, Messages.FeatureListObjectEditor_Title, values){

                            protected Control createContents(Composite parent) {
                                Composite control = (Composite)super.createContents(parent);
                                this.setDialogSize((Control)control);
                                return control;
                            }

                            protected void configureShell(Shell shell) {
                                super.configureShell(shell);
                            }

                            public void setDialogSize(Control parent) {
                                int y;
                                int height;
                                final String key = String.valueOf((this).FeatureListObjectEditor.this.featureEType.getName()) + ".list";
                                Point p = this.getShell().getSize();
                                int width = (this).FeatureListObjectEditor.this.preferenceStore.getInt("dialog." + key + ".width");
                                if (width == 0) {
                                    width = p.x;
                                }
                                if ((height = (this).FeatureListObjectEditor.this.preferenceStore.getInt("dialog." + key + ".height")) == 0) {
                                    height = p.y;
                                }
                                this.getShell().setSize(width, height);
                                p = this.getShell().getLocation();
                                int x = (this).FeatureListObjectEditor.this.preferenceStore.getInt("dialog." + key + ".x");
                                if (x == 0) {
                                    x = p.x;
                                }
                                if ((y = (this).FeatureListObjectEditor.this.preferenceStore.getInt("dialog." + key + ".y")) == 0) {
                                    y = p.y;
                                }
                                this.getShell().setLocation(x, y);
                                this.getShell().addControlListener(new ControlListener(){

                                    public void controlMoved(ControlEvent e) {
                                        Point p = this.getShell().getLocation();
                                        ((this).this).FeatureListObjectEditor.this.preferenceStore.setValue("dialog." + key + ".x", p.x);
                                        ((this).this).FeatureListObjectEditor.this.preferenceStore.setValue("dialog." + key + ".y", p.y);
                                    }

                                    public void controlResized(ControlEvent e) {
                                        Point p = this.getShell().getSize();
                                        ((this).this).FeatureListObjectEditor.this.preferenceStore.setValue("dialog." + key + ".width", p.x);
                                        ((this).this).FeatureListObjectEditor.this.preferenceStore.setValue("dialog." + key + ".height", p.y);
                                    }
                                });
                                if (parent.getLayoutData() instanceof GridData) {
                                    GridData data = (GridData)parent.getLayoutData();
                                    data.widthHint = width - 16;
                                    data.heightHint = height - 38;
                                }
                            }
                        };
                        if (featureEditorDialog.open() == 0) {
                            FeatureListObjectEditor.this.updateEObject((EList<EObject>)featureEditorDialog.getResult());
                            FeatureListObjectEditor.this.updateTextField();
                        }
                    }
                });
            }
        }
        return this.text;
    }

    private void updateEObject(final EObject result) {
        TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                if (result == null) {
                    FeatureListObjectEditor.this.references.clear();
                    return;
                }
                if (!FeatureListObjectEditor.this.references.contains(result)) {
                    FeatureListObjectEditor.this.references.add(result);
                }
            }
        });
    }

    private void updateEObject(final EList<EObject> result) {
        TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                if (result == null) {
                    FeatureListObjectEditor.this.references.clear();
                    return;
                }
                FeatureListObjectEditor.this.references.retainAll((Collection<?>)result);
                for (EObject di : result) {
                    if (FeatureListObjectEditor.this.references.contains(di)) continue;
                    FeatureListObjectEditor.this.references.add(di);
                }
            }
        });
    }

    private void updateTextField() {
        String listText = "";
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size() - 1) {
                listText = String.valueOf(listText) + ModelUtil.getDisplayName(this.references.get(i)) + ", ";
                ++i;
            }
            if (this.references.size() > 0) {
                listText = String.valueOf(listText) + ModelUtil.getDisplayName(this.references.get(this.references.size() - 1));
            }
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(this.getChoiceOfValues(this.object, this.feature).size() > 0);
        }
        this.text.setText(listText);
    }

    @Override
    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == -1 || this.object == notification.getNotifier() && this.feature == notification.getFeature()) {
            super.notifyChanged(notification);
            this.updateTextField();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.text.setVisible(visible);
        GridData data = (GridData)this.text.getLayoutData();
        boolean bl = data.exclude = !visible;
        if (this.buttons != null) {
            this.buttons.setVisible(visible);
            data = (GridData)this.buttons.getLayoutData();
            data.exclude = !visible;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.editButton != null && !this.editButton.isDisposed()) {
            this.editButton.dispose();
            this.editButton = null;
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
            this.text = null;
        }
        if (this.buttons != null && !this.buttons.isDisposed()) {
            this.buttons.dispose();
            this.buttons = null;
        }
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public List getValue() {
        Object v = this.object.eGet(this.feature);
        if (v instanceof List) {
            return (List)v;
        }
        return null;
    }

    private class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            return ModelUtil.getDisplayName(element);
        }
    }
}

