/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.clad;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListAndDetailCompositeBase;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.BooleanObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FeatureListObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FloatObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.IntObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ReadonlyTextObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractDetailComposite
extends ListAndDetailCompositeBase
implements ResourceSetListener {
    public final String EMPTY_LABEL_PROPERTY = "empty.label";
    protected Section attributesSection = null;
    protected Composite attributesComposite = null;
    protected Font descriptionFont = null;
    protected AbstractPropertiesProvider propertiesProvider = null;
    protected StyledText descriptionText = null;

    public AbstractDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public AbstractDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void setBusinessObject(EObject object) {
        super.setBusinessObject(object);
        this.cleanBindings();
        if (this.businessObject != null) {
            this.createBindings(this.businessObject);
            if (this.isEmpty()) {
                this.createEmptyLabel(this.businessObject);
            }
            this.redrawPage();
        }
    }

    protected void cleanBindings() {
        ModelUtil.disposeChildWidgets(this);
    }

    protected boolean isEmpty() {
        Control[] kids = this.getChildren();
        if (kids.length == 0) {
            return true;
        }
        return kids.length == 1 && "empty.label".equals(kids[0].getData());
    }

    protected void createEmptyLabel(EObject be) {
        boolean doit = false;
        Control[] kids = this.getChildren();
        if (kids.length == 0) {
            doit = true;
        } else if (kids.length == 1 && "empty.label".equals(kids[0].getData())) {
            doit = true;
        }
        if (doit) {
            String[] props;
            String text = NLS.bind((String)Messages.AbstractDetailComposite_Empty_Property_Sheet, (Object)be.eClass().getName());
            String elements = "";
            String[] stringArray = props = this.getPropertiesProvider().getProperties();
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                elements = String.valueOf(elements) + "    " + s + "\n";
                ++n2;
            }
            text = String.valueOf(text) + NLS.bind((String)Messages.AbstractDetailComposite_Empty_Property_Sheet_Elements, (Object)elements);
            Label label = this.createLabel(this, text);
            label.setData((Object)"empty.label");
        }
    }

    public Composite getAttributesParent() {
        if (this.getParent() instanceof Section) {
            return this;
        }
        if (this.attributesSection == null || this.attributesSection.isDisposed()) {
            this.attributesSection = this.createSection(this, Messages.AbstractDetailComposite_Attributes);
            this.attributesSection.setLayoutData((Object)new GridData(4, 128, true, true, 3, 1));
            this.attributesComposite = this.toolkit.createComposite((Composite)this.attributesSection);
            this.attributesSection.setClient((Control)this.attributesComposite);
            this.attributesComposite.setLayout((Layout)new GridLayout(3, false));
            final String prefName = "detail." + this.businessObject.eClass().getName() + ".expanded";
            this.attributesSection.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanging(ExpansionEvent e) {
                }

                public void expansionStateChanged(ExpansionEvent e) {
                    AbstractDetailComposite.this.preferenceStore.setValue(prefName, e.getState());
                    AbstractDetailComposite.this.redrawPage();
                }
            });
            boolean expanded = this.preferenceStore.contains(prefName) ? this.preferenceStore.getBoolean(prefName) : true;
            this.attributesSection.setExpanded(expanded);
        }
        return this.attributesComposite;
    }

    public void setTitle(String title) {
        this.getAttributesParent();
        if (this.attributesSection != null) {
            this.attributesSection.setText(title);
        }
    }

    public abstract void createBindings(EObject var1);

    protected EStructuralFeature getFeature(EObject object, String name) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(name);
        if (feature == null) {
            List<EStructuralFeature> anyAttributes = ModelUtil.getAnyAttributes(object);
            for (EStructuralFeature f : anyAttributes) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
        }
        return feature;
    }

    protected boolean isAttribute(EObject object, EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            return true;
        }
        if (feature != null) {
            List<EStructuralFeature> anyAttributes = ModelUtil.getAnyAttributes(object);
            for (EStructuralFeature f : anyAttributes) {
                if (!f.getName().equals(feature.getName())) continue;
                if (!(f instanceof EAttribute)) break;
                return true;
            }
        }
        return false;
    }

    protected boolean isList(EObject object, EStructuralFeature feature) {
        if (feature != null) {
            Object list = object.eGet(feature);
            return list instanceof EObjectContainmentEList;
        }
        return false;
    }

    protected boolean isReference(EObject object, EStructuralFeature feature) {
        if (feature != null) {
            List<EStructuralFeature> anyAttributes = ModelUtil.getAnyAttributes(object);
            for (EStructuralFeature f : anyAttributes) {
                if (!f.getName().equals(feature.getName())) continue;
                if (!(f instanceof EReference)) break;
                return true;
            }
        }
        return feature instanceof EReference;
    }

    protected Label createLabel(Composite parent, String name) {
        Label label = this.toolkit.createLabel(parent, name);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        return label;
    }

    public Font getDescriptionFont() {
        if (this.descriptionFont == null) {
            Display display = Display.getCurrent();
            FontData data = display.getSystemFont().getFontData()[0];
            this.descriptionFont = new Font((Device)display, data.getName(), data.getHeight() + 1, 0);
        }
        return this.descriptionFont;
    }

    protected StyledText createDescription(Composite parent, String description) {
        Display display = Display.getCurrent();
        this.descriptionText = new StyledText(parent, 2634);
        this.descriptionText.setText(description);
        this.descriptionText.setFont(this.getDescriptionFont());
        this.descriptionText.setBackground(display.getSystemColor(29));
        this.descriptionText.setForeground(display.getSystemColor(28));
        this.descriptionText.setData("do_not_adapt", (Object)Boolean.TRUE);
        GridData d = new GridData(4, 4, false, false, 3, 1);
        d.horizontalIndent = 4;
        d.verticalIndent = 4;
        d.heightHint = (int)(5.5 * (double)this.getDescriptionFont().getFontData()[0].getHeight());
        d.widthHint = 100;
        this.descriptionText.setLayoutData((Object)d);
        return this.descriptionText;
    }

    protected Section createSection(Composite parent, final String title) {
        Section section = this.toolkit.createSection(parent, 322);
        section.setText(title);
        if (this.getBusinessObject() != null) {
            String prefKey = "section." + this.getBusinessObject().eClass().getName() + title + "." + ".expanded";
            boolean expanded = this.preferenceStore.getBoolean(prefKey);
            section.setExpanded(expanded);
        }
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                if (AbstractDetailComposite.this.getBusinessObject() != null) {
                    String prefKey = "section." + AbstractDetailComposite.this.getBusinessObject().eClass().getName() + title + "." + ".expanded";
                    AbstractDetailComposite.this.preferenceStore.setValue(prefKey, e.getState());
                }
            }
        });
        return section;
    }

    protected Section createSubSection(Composite parent, String title) {
        Section section = this.toolkit.createSection(parent, 320);
        section.setText(title);
        section.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        return section;
    }

    protected void bindAttribute(EObject object, String name) {
        this.bindAttribute(null, object, name, null);
    }

    protected void bindAttribute(EObject object, String name, String label) {
        this.bindAttribute(null, object, name, label);
    }

    protected void bindAttribute(Composite parent, EObject object, String name) {
        this.bindAttribute(parent, object, name, null);
    }

    protected void bindAttribute(Composite parent, EObject object, String name, String label) {
        EStructuralFeature feature = this.getFeature(object, name);
        if (this.isAttribute(object, feature)) {
            this.bindAttribute(parent, object, (EAttribute)feature, label);
        }
    }

    protected void bindAttribute(EObject object, EAttribute attribute) {
        this.bindAttribute(null, object, attribute, null);
    }

    protected void bindAttribute(EObject object, EAttribute attribute, String label) {
        this.bindAttribute(null, object, attribute, label);
    }

    protected void bindAttribute(Composite parent, EObject object, EAttribute attribute) {
        this.bindAttribute(parent, object, attribute, null);
    }

    protected void bindAttribute(Composite parent, EObject object, EAttribute attribute, String label) {
        if (this.isModelObjectEnabled(object.eClass(), (EStructuralFeature)attribute) || "anyAttribute".equals(attribute.getName())) {
            if (parent == null) {
                parent = this.getAttributesParent();
            }
            if (label == null) {
                label = this.getPropertiesProvider().getLabel(object, (EStructuralFeature)attribute);
            }
            Class eTypeClass = attribute.getEType().getInstanceClass();
            if (ModelUtil.isMultiChoice(object, (EStructuralFeature)attribute)) {
                ComboObjectEditor editor = new ComboObjectEditor(this, object, (EStructuralFeature)attribute);
                editor.createControl(parent, label);
            } else if (String.class.equals((Object)eTypeClass)) {
                TextObjectEditor editor = new TextObjectEditor(this, object, (EStructuralFeature)attribute);
                editor.createControl(parent, label);
            } else if (Boolean.class.equals((Object)eTypeClass) || Boolean.TYPE.equals(eTypeClass)) {
                BooleanObjectEditor editor = new BooleanObjectEditor(this, object, (EStructuralFeature)attribute);
                editor.createControl(parent, label);
            } else if (Integer.TYPE.equals(eTypeClass) || Short.class.equals((Object)eTypeClass) || Integer.class.equals((Object)eTypeClass) || BigInteger.class.equals((Object)eTypeClass) || Short.TYPE.equals(eTypeClass) || Integer.TYPE.equals(eTypeClass) || Long.TYPE.equals(eTypeClass)) {
                IntObjectEditor editor = new IntObjectEditor(this, object, (EStructuralFeature)attribute);
                editor.createControl(parent, label);
            } else if (Integer.TYPE.equals(eTypeClass) || Float.class.equals((Object)eTypeClass) || Double.class.equals((Object)eTypeClass) || Float.TYPE.equals(eTypeClass) || Double.TYPE.equals(eTypeClass)) {
                FloatObjectEditor editor = new FloatObjectEditor(this, object, (EStructuralFeature)attribute);
                editor.createControl(parent, label);
            } else if ("anyAttribute".equals(attribute.getName()) || object.eGet((EStructuralFeature)attribute) instanceof FeatureMap) {
                List basicList = ((BasicFeatureMap)object.eGet((EStructuralFeature)attribute)).basicList();
                for (FeatureMap.Entry entry : basicList) {
                    EStructuralFeature feature = entry.getEStructuralFeature();
                    if (this.isAttribute(object, feature)) {
                        this.bindAttribute(parent, object, (EAttribute)feature);
                        continue;
                    }
                    if (this.isReference(object, feature)) {
                        this.bindReference(parent, object, (EReference)feature);
                        continue;
                    }
                    if (!this.isList(object, feature)) continue;
                    this.bindList(object, feature);
                }
            }
        }
    }

    protected void bindReference(Composite parent, EObject object, String name) {
        EStructuralFeature feature = this.getFeature(object, name);
        if (this.isReference(object, feature)) {
            this.bindReference(parent, object, (EReference)feature);
        }
    }

    protected void bindReference(EObject object, String name) {
        EStructuralFeature feature = this.getFeature(object, name);
        if (this.isReference(object, feature)) {
            this.bindReference(object, (EReference)feature);
        }
    }

    protected void bindReference(EObject object, EReference reference) {
        this.bindReference(null, object, reference);
    }

    protected void bindReference(Composite parent, EObject object, EReference reference) {
        if (this.isModelObjectEnabled(object.eClass(), (EStructuralFeature)reference)) {
            if (parent == null) {
                parent = this.getAttributesParent();
            }
            String displayName = this.getPropertiesProvider().getLabel(object, (EStructuralFeature)reference);
            ObjectEditor editor = null;
            editor = ModelUtil.isMultiChoice(object, (EStructuralFeature)reference) ? (reference.isMany() ? new FeatureListObjectEditor(this, object, (EStructuralFeature)reference) : new ComboObjectEditor(this, object, (EStructuralFeature)reference)) : (ModelUtil.canCreateNew(object, (EStructuralFeature)reference) ? new ReadonlyTextObjectEditor(this, object, (EStructuralFeature)reference) : new TextObjectEditor(this, object, (EStructuralFeature)reference));
            if (editor != null) {
                editor.createControl(parent, displayName);
            }
        }
    }

    protected AbstractListComposite bindList(EObject object, String name) {
        EStructuralFeature feature = this.getFeature(object, name);
        if (this.isList(object, feature)) {
            return this.bindList(object, feature);
        }
        return null;
    }

    protected AbstractListComposite bindList(EObject object, EStructuralFeature feature) {
        return this.bindList(object, feature, null);
    }

    protected AbstractListComposite bindList(EObject object, EStructuralFeature feature, EClass listItemClass) {
        AbstractListComposite tableComposite = null;
        if (this.isModelObjectEnabled(object.eClass(), feature) || this.isModelObjectEnabled(listItemClass)) {
            Class clazz = listItemClass != null ? listItemClass.getInstanceClass() : feature.getEType().getInstanceClass();
            tableComposite = this.propertySection != null ? PropertiesCompositeFactory.INSTANCE.createListComposite(clazz, this.propertySection) : PropertiesCompositeFactory.INSTANCE.createListComposite(clazz, this, 28835840);
            tableComposite.setListItemClass(listItemClass);
            tableComposite.bindList(object, feature);
        }
        return tableComposite;
    }

    protected AbstractListComposite bindList(Composite parent, EObject object, EStructuralFeature feature, EClass listItemClass) {
        AbstractListComposite tableComposite = null;
        if (this.isModelObjectEnabled(object.eClass(), feature) || this.isModelObjectEnabled(listItemClass)) {
            Class clazz = listItemClass != null ? listItemClass.getInstanceClass() : feature.getEType().getInstanceClass();
            tableComposite = PropertiesCompositeFactory.INSTANCE.createListComposite(clazz, parent, 28835840);
            tableComposite.setListItemClass(listItemClass);
            tableComposite.bindList(object, feature);
        }
        return tableComposite;
    }

    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<Control> kids = new ArrayList<Control>();
                AbstractDetailComposite parent = AbstractDetailComposite.this;
                try {
                    AbstractBpmn2PropertySection section = AbstractDetailComposite.this.getPropertySection();
                    if (section != null && section.getTabbedPropertySheetPage() != null) {
                        parent = (Composite)section.getTabbedPropertySheetPage().getControl();
                    }
                }
                catch (Exception exception) {}
                ENotificationImpl n = new ENotificationImpl(null, -1, -1, 0, 0);
                AbstractDetailComposite.this.getAllChildWidgets(parent, kids);
                for (Control c : kids) {
                    INotifyChangedListener listener = (INotifyChangedListener)c.getData("notify.changed.listener");
                    if (listener == null) continue;
                    listener.notifyChanged((Notification)n);
                }
            }
        });
    }

    public void setPropertiesProvider(AbstractPropertiesProvider provider) {
        this.propertiesProvider = provider;
    }

    public AbstractPropertiesProvider getPropertiesProvider() {
        return this.getPropertiesProvider(this.businessObject);
    }

    public AbstractPropertiesProvider getPropertiesProvider(EObject object) {
        if (this.propertiesProvider == null) {
            final EObject o = object;
            return new AbstractPropertiesProvider(object){

                @Override
                public String[] getProperties() {
                    ArrayList<String> list = new ArrayList<String>();
                    EClass c = o.eClass();
                    if (c.getEStructuralFeature("name") != null) {
                        list.add("name");
                    }
                    if (c.getEStructuralFeature("id") != null) {
                        list.add("id");
                    }
                    for (EStructuralFeature attribute : o.eClass().getEStructuralFeatures()) {
                        if (list.contains(attribute.getName())) continue;
                        list.add(attribute.getName());
                    }
                    List<EStructuralFeature> anyAttributes = ModelUtil.getAnyAttributes(o);
                    for (EStructuralFeature f : anyAttributes) {
                        if (!(f instanceof EAttribute) || list.contains(f.getName())) continue;
                        list.add(f.getName());
                    }
                    String[] a = new String[list.size()];
                    list.toArray(a);
                    return a;
                }
            };
        }
        return this.propertiesProvider;
    }
}

