/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.participant;

import java.util.List;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ResizeParticipantFeature
extends DefaultResizeShapeFeature {
    public static final String POOL_RESIZE_PROPERTY = "pool.resize";
    public static final String RESIZE_FIRST_LANE = "resize.first.lane";

    public ResizeParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        PictogramElement containerElem;
        EObject container = context.getShape().eContainer();
        if (container instanceof PictogramElement && BusinessObjectUtil.containsElementOfType(containerElem = (PictogramElement)container, ChoreographyActivity.class)) {
            return false;
        }
        return super.canResizeShape(context);
    }

    private void resizeLaneHeight(IResizeShapeContext context) {
        ContainerShape participantShape = (ContainerShape)context.getShape();
        GraphicsAlgorithm ga = participantShape.getGraphicsAlgorithm();
        ContainerShape laneToResize = null;
        GraphicsAlgorithm laneToResizeGA = null;
        int width = 0;
        int height = 0;
        int x = 0;
        int y = 0;
        boolean resizeFirstLane = false;
        boolean resize = false;
        if (FeatureSupport.isHorizontal(participantShape)) {
            int dHeight = context.getHeight() - ga.getHeight();
            if (dHeight != 0) {
                resize = true;
                if (context.getY() != ga.getY()) {
                    laneToResize = (ContainerShape)FeatureSupport.getFirstLaneInContainer(participantShape);
                    resizeFirstLane = true;
                } else {
                    laneToResize = (ContainerShape)FeatureSupport.getLastLaneInContainer(participantShape);
                }
                laneToResizeGA = laneToResize.getGraphicsAlgorithm();
                width = laneToResizeGA.getWidth();
                height = laneToResizeGA.getHeight() + dHeight;
                x = laneToResizeGA.getX();
                y = laneToResizeGA.getY();
            }
        } else {
            int dWidth = context.getWidth() - ga.getWidth();
            if (dWidth != 0) {
                resize = true;
                if (context.getX() != ga.getX()) {
                    laneToResize = (ContainerShape)FeatureSupport.getFirstLaneInContainer(participantShape);
                    resizeFirstLane = true;
                } else {
                    laneToResize = (ContainerShape)FeatureSupport.getLastLaneInContainer(participantShape);
                }
                laneToResizeGA = laneToResize.getGraphicsAlgorithm();
                width = laneToResizeGA.getWidth() + dWidth;
                height = laneToResizeGA.getHeight();
                x = laneToResizeGA.getX();
                y = laneToResizeGA.getY();
            }
        }
        if (resize) {
            ResizeShapeContext newContext = new ResizeShapeContext(laneToResize);
            newContext.setLocation(x, y);
            newContext.setHeight(height);
            newContext.setWidth(width);
            newContext.putProperty((Object)POOL_RESIZE_PROPERTY, (Object)true);
            newContext.putProperty((Object)RESIZE_FIRST_LANE, (Object)resizeFirstLane);
            IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
            if (resizeFeature.canResizeShape((IResizeShapeContext)newContext)) {
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
            }
            if (FeatureSupport.isHorizontal(participantShape)) {
                ((ResizeShapeContext)context).setHeight(ga.getHeight());
            } else {
                ((ResizeShapeContext)context).setWidth(ga.getWidth());
            }
        }
    }

    private void resizeLaneWidth(IResizeShapeContext context) {
        ContainerShape participantShape = (ContainerShape)context.getShape();
        GraphicsAlgorithm ga = participantShape.getGraphicsAlgorithm();
        int dHeight = context.getHeight() - ga.getHeight();
        int dWidth = context.getWidth() - ga.getWidth();
        if (dWidth != 0 && FeatureSupport.isHorizontal(participantShape) || dHeight != 0 && !FeatureSupport.isHorizontal(participantShape)) {
            List<PictogramElement> childrenShapes = FeatureSupport.getChildsOfBusinessObjectType(participantShape, Lane.class);
            for (PictogramElement currentPicElem : childrenShapes) {
                if (!(currentPicElem instanceof ContainerShape)) continue;
                ContainerShape currentContainerShape = (ContainerShape)currentPicElem;
                GraphicsAlgorithm laneGA = currentContainerShape.getGraphicsAlgorithm();
                ResizeShapeContext newContext = new ResizeShapeContext((Shape)currentContainerShape);
                newContext.setLocation(laneGA.getX(), laneGA.getY());
                if (FeatureSupport.isHorizontal(participantShape)) {
                    newContext.setWidth(laneGA.getWidth() + dWidth);
                    newContext.setHeight(laneGA.getHeight());
                } else {
                    newContext.setHeight(laneGA.getHeight() + dHeight);
                    newContext.setWidth(laneGA.getWidth());
                }
                newContext.putProperty((Object)POOL_RESIZE_PROPERTY, (Object)true);
                IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
                if (!resizeFeature.canResizeShape((IResizeShapeContext)newContext)) continue;
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
            }
        }
    }

    public void resizeShape(IResizeShapeContext context) {
        ContainerShape poolShape = (ContainerShape)context.getShape();
        GraphicsAlgorithm poolGa = poolShape.getGraphicsAlgorithm();
        int preX = poolGa.getX();
        int preY = poolGa.getY();
        if (BusinessObjectUtil.containsChildElementOfType(context.getPictogramElement(), Lane.class)) {
            this.resizeLaneHeight(context);
            this.resizeLaneWidth(context);
        }
        super.resizeShape(context);
        int deltaX = preX - context.getX();
        int deltaY = preY - context.getY();
        for (Shape shape : poolShape.getChildren()) {
            if (!(shape instanceof ContainerShape)) continue;
            EObject bo = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape);
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            if (bo instanceof Lane) continue;
            Graphiti.getLayoutService().setLocation(ga, ga.getX() + deltaX, ga.getY() + deltaY);
        }
    }
}

