/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import java.io.IOException;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveLaneFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromParticipantToLaneFeature
extends MoveLaneFeature {
    public MoveFromParticipantToLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        boolean targetHasFlowNodeRefs;
        Lane movedLane = this.getMovedLane(context);
        boolean moveableHasFlowNodes = movedLane.getFlowNodeRefs().size() > 0;
        Lane targetLane = this.getTargetLane(context);
        boolean bl = targetHasFlowNodeRefs = targetLane.getFlowNodeRefs().size() > 0;
        if (!moveableHasFlowNodes && !targetHasFlowNodeRefs) {
            return true;
        }
        return moveableHasFlowNodes ^ targetHasFlowNodeRefs;
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        this.modifyModelStructure(context);
        FeatureSupport.redraw(context.getSourceContainer());
        FeatureSupport.redraw(context.getTargetContainer());
    }

    private Lane getTargetLane(IMoveShapeContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
    }

    private void modifyModelStructure(IMoveShapeContext context) {
        Lane movedLane = this.getMovedLane(context);
        Lane toLane = this.getTargetLane(context);
        try {
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            Participant participant = handler.getParticipant(toLane);
            handler.moveLane(movedLane, participant);
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        Participant sourceParticipant = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
        LaneSet laneSet = null;
        for (LaneSet set : sourceParticipant.getProcessRef().getLaneSets()) {
            if (!set.getLanes().contains(movedLane)) continue;
            laneSet = set;
            break;
        }
        if (laneSet != null) {
            laneSet.getLanes().remove(movedLane);
            if (laneSet.getLanes().isEmpty()) {
                sourceParticipant.getProcessRef().getLaneSets().remove(laneSet);
            }
        }
        if (toLane.getChildLaneSet() == null) {
            LaneSet createLaneSet = Bpmn2ModelerFactory.create(LaneSet.class);
            toLane.setChildLaneSet(createLaneSet);
            ModelUtil.setID((EObject)createLaneSet);
        }
        toLane.getChildLaneSet().getLanes().add(movedLane);
    }
}

