/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import java.io.IOException;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveLaneFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromParticipantToDiagramFeature
extends MoveLaneFeature {
    public MoveFromParticipantToDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        return true;
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        this.modifyModelStructure(context);
        FeatureSupport.redraw(context.getSourceContainer());
    }

    private void modifyModelStructure(IMoveShapeContext context) {
        Lane movedLane = this.getMovedLane(context);
        Participant sourceParticipant = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
        Participant internalParticipant = null;
        try {
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            internalParticipant = handler.getInternalParticipant();
            handler.moveLane(movedLane, internalParticipant);
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        LaneSet laneSet = null;
        for (LaneSet set : sourceParticipant.getProcessRef().getLaneSets()) {
            if (!set.getLanes().contains(movedLane)) continue;
            laneSet = set;
            break;
        }
        if (laneSet != null) {
            Process process;
            laneSet.getLanes().remove(movedLane);
            if (laneSet.getLanes().isEmpty()) {
                sourceParticipant.getProcessRef().getLaneSets().remove(laneSet);
            }
            if ((process = internalParticipant.getProcessRef()).getLaneSets().isEmpty()) {
                LaneSet createLaneSet = Bpmn2ModelerFactory.create(LaneSet.class);
                process.getLaneSets().add(createLaneSet);
                ModelUtil.setID((EObject)createLaneSet);
            }
            ((LaneSet)process.getLaneSets().get(0)).getLanes().add(movedLane);
        }
    }
}

