/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.lane;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.features.lane.MoveLaneFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class MoveFromDiagramToLaneFeature
extends MoveLaneFeature {
    public MoveFromDiagramToLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        boolean targetHasFlowNodeRefs;
        Lane movedLane = this.getMovedLane(context);
        boolean moveableHasFlowNodes = movedLane.getFlowNodeRefs().size() > 0;
        Lane targetLane = this.getTargetLane(context);
        boolean bl = targetHasFlowNodeRefs = targetLane.getFlowNodeRefs().size() > 0;
        if (!moveableHasFlowNodes && !targetHasFlowNodeRefs) {
            return true;
        }
        return moveableHasFlowNodes ^ targetHasFlowNodeRefs;
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        IGaService gaService = Graphiti.getGaService();
        Lane movedLane = this.getMovedLane(context);
        GraphicsAlgorithm laneGa = context.getShape().getGraphicsAlgorithm();
        Lane targetLane = this.getTargetLane(context);
        GraphicsAlgorithm tga = context.getTargetContainer().getGraphicsAlgorithm();
        List<Shape> shapes = this.getFlowNodeShapes(context, targetLane);
        this.modifyModelStructure(targetLane, movedLane);
        if (this.getNumberOfLanes((ITargetContext)context) == 1) {
            gaService.setLocationAndSize(laneGa, 15, 0, tga.getWidth() - 15, tga.getHeight());
            for (Shape s : shapes) {
                GraphicsUtil.sendToFront(s);
                s.setContainer((ContainerShape)context.getShape());
            }
        } else {
            gaService.setLocationAndSize(laneGa, 15, tga.getHeight() - 1, tga.getWidth() - 15, laneGa.getHeight() + 1);
        }
        FeatureSupport.redraw(context.getTargetContainer());
    }

    private void modifyModelStructure(Lane targetLane, Lane lane) {
        EObject container;
        LaneSet laneSet = (LaneSet)lane.eContainer();
        laneSet.getLanes().remove(lane);
        if (laneSet.getLanes().size() == 0 && (container = laneSet.eContainer()) instanceof Process) {
            Process p = (Process)container;
            p.getLaneSets().remove(laneSet);
        }
        if (targetLane.getChildLaneSet() == null) {
            LaneSet createLaneSet = Bpmn2ModelerFactory.create(LaneSet.class);
            targetLane.setChildLaneSet(createLaneSet);
            ModelUtil.setID((EObject)createLaneSet);
        }
        List lanes = targetLane.getChildLaneSet().getLanes();
        lanes.add(lane);
        if (lanes.size() == 1) {
            List flowNodeRefs = targetLane.getFlowNodeRefs();
            for (FlowNode flowNode : flowNodeRefs) {
                flowNode.getLanes().add(lane);
            }
            targetLane.getFlowNodeRefs().clear();
        }
    }

    private List<Shape> getFlowNodeShapes(IMoveShapeContext context, Lane lane) {
        List nodes = lane.getFlowNodeRefs();
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Shape s : context.getTargetContainer().getChildren()) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)s);
            if (bo == null || !nodes.contains(bo)) continue;
            shapes.add(s);
        }
        return shapes;
    }

    private int getNumberOfLanes(ITargetContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        Lane lane = (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
        return lane.getChildLaneSet().getLanes().size();
    }

    private Lane getTargetLane(IMoveShapeContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        return (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
    }
}

