/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.label;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class LayoutLabelFeature
extends AbstractLayoutFeature {
    public LayoutLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        return true;
    }

    public boolean layout(ILayoutContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        SubProcess subProcess = BusinessObjectUtil.getFirstElementOfType(pictogramElement, SubProcess.class);
        if (subProcess != null && pictogramElement instanceof ContainerShape) {
            try {
                ContainerShape containerShape = (ContainerShape)pictogramElement;
                BPMNShape shape = DIUtils.findBPMNShape((BaseElement)subProcess);
                if (shape.isIsExpanded()) {
                    boolean needResize = false;
                    GraphicsAlgorithm parentGa = containerShape.getGraphicsAlgorithm();
                    for (PictogramElement pe : FeatureSupport.getContainerChildren(containerShape)) {
                        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
                        if (ga == null) continue;
                        if (ga.getX() < 0 || ga.getY() < 0) {
                            needResize = true;
                            break;
                        }
                        if (ga.getX() + ga.getWidth() > parentGa.getWidth()) {
                            needResize = true;
                            break;
                        }
                        if (ga.getY() + ga.getHeight() <= parentGa.getHeight()) continue;
                        needResize = true;
                        break;
                    }
                    if (needResize) {
                        ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                        resizeContext.setX(parentGa.getX());
                        resizeContext.setY(parentGa.getY());
                        resizeContext.setWidth(parentGa.getWidth());
                        resizeContext.setHeight(parentGa.getHeight());
                        IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                        resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                    }
                    FeatureSupport.setContainerChildrenVisible(containerShape, true);
                } else {
                    FeatureSupport.setContainerChildrenVisible(containerShape, false);
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }
}

